/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.utils;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.command.InitFromTemplateCommand;
import org.eclipse.papyrus.uml.diagram.wizards.command.NewPapyrusModelCommand;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Package;

public class ModelTemplate {
    ServicesRegistry registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
    ModelSet modelSet;

    public ModelTemplate(URI uri, String extension) throws ServiceException {
        this.registry.startServicesByClassKeys(new Class[]{ModelSet.class});
        this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        TransactionalEditingDomain domain = this.modelSet.getTransactionalEditingDomain();
        NewPapyrusModelCommand command = new NewPapyrusModelCommand(this.modelSet, uri);
        domain.getCommandStack().execute((Command)command);
        String templateName = "templates/robotics." + extension;
        InitFromTemplateCommand tp = new InitFromTemplateCommand(this.modelSet.getTransactionalEditingDomain(), this.modelSet, "org.eclipse.papyrus.robotics.wizards", String.valueOf(templateName) + ".uml", String.valueOf(templateName) + ".notation", String.valueOf(templateName) + ".di");
        domain.getCommandStack().execute((Command)tp);
    }

    public Package getUMLModel() {
        UmlModel umlModel = UmlUtils.getUmlModel((ModelSet)this.modelSet);
        try {
            return (Package)umlModel.lookupRoot();
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public void save(IProgressMonitor progressMonitor) {
        try {
            this.modelSet.save(progressMonitor);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public TransactionalEditingDomain getDomain() {
        return this.modelSet.getTransactionalEditingDomain();
    }

    public void executeCmd(Command command) {
        this.getDomain().getCommandStack().execute(command);
    }

    public NotationModel getNotationModel() {
        return NotationUtils.getNotationModel((ModelSet)this.modelSet);
    }

    public void dispose() throws ServiceMultiException {
        this.registry.disposeRegistry();
    }
}

