/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.service.types.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

public final class PropertyPathUtil {
    private PropertyPathUtil() {
    }

    public static Classifier getCompositeContext(View view) {
        View currentView = view;
        while (currentView != null) {
            if (currentView instanceof Shape && currentView.getElement() instanceof Classifier) {
                return (Classifier)currentView.getElement();
            }
            currentView = (View)currentView.eContainer();
        }
        return null;
    }

    public static List<Property> getPropertyListFromView(View view) {
        ArrayList<Property> propertiesList = new ArrayList<Property>();
        View currentView = view;
        while (currentView != null) {
            if (currentView instanceof Shape && currentView.getElement() instanceof Property) {
                propertiesList.add((Property)currentView.getElement());
            }
            currentView = (View)currentView.eContainer();
        }
        return propertiesList;
    }

    public static List<Property> getPropertyPath(View sourceView) {
        List<Property> propertyList = PropertyPathUtil.getPropertyListFromView(sourceView);
        if (!propertyList.isEmpty()) {
            propertyList.remove(0);
            Collections.reverse(propertyList);
        }
        return propertyList;
    }
}

