/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TableUtil {
    public static List<Table> getAssociatedTables(EObject element, ResourceSet resourceSet) {
        List<Table> result;
        if (resourceSet == null) {
            resourceSet = EMFHelper.getResourceSet((EObject)element);
        }
        if (resourceSet == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<Table>(3);
            for (EStructuralFeature.Setting setting : EMFHelper.getUsages((EObject)element)) {
                if (setting.getEStructuralFeature() != NattablePackage.Literals.TABLE__OWNER || EMFHelper.getResourceSet((EObject)setting.getEObject()) != resourceSet) continue;
                result.add((Table)setting.getEObject());
            }
        }
        return result;
    }

    public static List<Table> getAssociatedTablesFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Table> tables = new LinkedList<Table>();
            for (EObject eObj : notationResource.getContents()) {
                Table table;
                if (!(eObj instanceof Table) || !element.equals((table = (Table)eObj).getOwner())) continue;
                tables.add(table);
            }
            return tables;
        }
        return Collections.emptyList();
    }
}

