/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.base.scope.WorkingSetScope;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.help.ui.internal.views.ScopeState;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class HyperlinkTreePart
extends AbstractFormPart
implements IHelpPart {
    protected ReusableHelpPart parent;
    private String id;
    protected TreeViewer treeViewer;
    private TreeItem lastItem;
    private ScopeObserver scopeObserver;

    public HyperlinkTreePart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        Cursor handCursor = parent.getDisplay().getSystemCursor(21);
        this.treeViewer = new TreeViewer(parent, 768);
        this.treeViewer.getTree().setMenu(parent.getMenu());
        this.treeViewer.getTree().setForeground(toolkit.getHyperlinkGroup().getForeground());
        this.configureTreeViewer();
        this.treeViewer.setInput((Object)this);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addOpenListener(event -> this.doOpenSelection((IStructuredSelection)event.getSelection()));
        this.treeViewer.addSelectionChangedListener(event -> this.handleSelectionChanged(event.getStructuredSelection()));
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){
            long lastTime;

            public void mouseUp(MouseEvent e) {
                Object obj;
                long eventTime = (long)e.time & 0xFFFFFFFFL;
                if (eventTime - this.lastTime <= (long)e.display.getDoubleClickTime()) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                this.lastTime = eventTime;
                Point p = new Point(e.x, e.y);
                TreeItem item = HyperlinkTreePart.this.treeViewer.getTree().getItem(p);
                if (item != null && (obj = item.getData()) != null) {
                    HyperlinkTreePart.this.doOpen(obj);
                }
            }
        });
        this.treeViewer.getTree().addPaintListener(e -> {
            this.validateLastItem();
            if (this.lastItem == null) {
                return;
            }
            Rectangle bounds = this.lastItem.getBounds();
            boolean selected = false;
            TreeItem[] items = this.lastItem.getParent().getSelection();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.lastItem)) {
                    selected = true;
                    break;
                }
                ++i;
            }
            if (selected) {
                e.gc.setForeground(e.display.getSystemColor(27));
            } else {
                e.gc.setForeground(toolkit.getHyperlinkGroup().getActiveForeground());
            }
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int lineY = bounds.y + height;
            e.gc.drawLine(bounds.x, lineY, bounds.x + bounds.width - 1, lineY);
        });
        this.treeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                HyperlinkTreePart.this.validateLastItem();
                if (HyperlinkTreePart.this.lastItem != null) {
                    TreeItem item = HyperlinkTreePart.this.lastItem;
                    HyperlinkTreePart.this.lastItem = null;
                    item.setForeground(null);
                }
            }
        });
        this.treeViewer.getTree().addMouseMoveListener(e -> {
            Point p = new Point(e.x, e.y);
            TreeItem item = this.treeViewer.getTree().getItem(p);
            this.validateLastItem();
            if (item != null) {
                if (this.lastItem != null) {
                    if (!this.lastItem.equals(item)) {
                        this.lastItem.setForeground(null);
                        this.repaintItem(this.lastItem);
                        this.updateStatus(null);
                        this.lastItem = null;
                    } else {
                        return;
                    }
                }
                Object obj = item.getData();
                this.treeViewer.getTree().setCursor(handCursor);
                ITreeSelection ssel = this.treeViewer.getStructuredSelection();
                if (ssel.getFirstElement() == obj) {
                    item.setForeground(e.display.getSystemColor(27));
                } else {
                    item.setForeground(toolkit.getHyperlinkGroup().getActiveForeground());
                }
                this.lastItem = item;
                this.repaintItem(this.lastItem);
                if (obj instanceof IHelpResource) {
                    this.updateStatus((IHelpResource)obj);
                } else {
                    this.updateStatus(null);
                }
                return;
            }
            if (this.lastItem != null) {
                this.lastItem.setForeground(null);
                this.repaintItem(this.lastItem);
                this.lastItem = null;
                this.updateStatus(null);
            }
            this.treeViewer.getTree().setCursor(null);
        });
        this.contributeToToolBar(tbm);
        this.scopeObserver = new ScopeObserver();
        ScopeState.getInstance().getScopeSetManager().addObserver(this.scopeObserver);
    }

    public void dispose() {
        if (this.scopeObserver != null) {
            ScopeState.getInstance().getScopeSetManager().deleteObserver(this.scopeObserver);
        }
        super.dispose();
    }

    private void repaintItem(TreeItem item) {
        Rectangle bounds = item.getBounds();
        item.getParent().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    protected void contributeToToolBar(IToolBarManager tbm) {
        Action collapseAllAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)HyperlinkTreePart.this.getControl().getDisplay(), () -> HyperlinkTreePart.this.doCollapseAll());
            }
        };
        collapseAllAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/collapseall.gif"));
        collapseAllAction.setToolTipText(Messages.AllTopicsPart_collapseAll_tooltip);
        tbm.insertBefore("back", (IAction)collapseAllAction);
        tbm.insertBefore("back", (IContributionItem)new Separator());
    }

    private void doCollapseAll() {
        Object[] expanded = this.treeViewer.getExpandedElements();
        this.treeViewer.collapseAll();
        this.treeViewer.update(expanded, null);
    }

    @Override
    public Control getControl() {
        return this.treeViewer.getControl();
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        this.refilter();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.treeViewer.refresh();
        }
    }

    private void doOpenSelection(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj != null) {
            this.doOpen(obj);
        }
    }

    protected void handleSelectionChanged(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (this.lastItem != null && !this.lastItem.isDisposed()) {
            Object lastObj = this.lastItem.getData();
            if (lastObj == obj) {
                this.lastItem.setForeground(this.getControl().getDisplay().getSystemColor(27));
            } else {
                this.lastItem.setForeground(this.parent.getForm().getToolkit().getHyperlinkGroup().getActiveForeground());
            }
            this.repaintItem(this.lastItem);
        }
        if (obj instanceof IHelpResource) {
            IHelpResource res = (IHelpResource)obj;
            this.updateStatus(res, false);
        } else {
            this.updateStatus(null, false);
        }
    }

    private void updateStatus(IHelpResource res) {
        this.updateStatus(res, true);
    }

    private void updateStatus(IHelpResource res, boolean defaultToSelection) {
        ITreeSelection ssel;
        Object obj;
        if (defaultToSelection && res == null && (obj = (ssel = this.treeViewer.getStructuredSelection()).getFirstElement()) instanceof IHelpResource) {
            res = (IHelpResource)obj;
        }
        if (res != null) {
            String label = res.getLabel();
            String href = this.getHref(res);
            this.parent.handleLinkEntered(new HyperlinkEvent((Widget)this.treeViewer.getTree(), (Object)href, label, 0));
        } else {
            this.parent.handleLinkExited(null);
        }
    }

    protected String getHref(IHelpResource res) {
        return res.getHref();
    }

    protected abstract void configureTreeViewer();

    protected abstract void doOpen(Object var1);

    protected void postUpdate(Object obj) {
        this.treeViewer.getControl().getDisplay().asyncExec(() -> this.treeViewer.update(obj, null));
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillSelectionProviderMenu((ISelectionProvider)this.treeViewer, manager, this.canAddBookmarks());
    }

    protected abstract boolean canAddBookmarks();

    @Override
    public boolean hasFocusControl(Control focusControl) {
        return this.treeViewer.getControl().equals(focusControl);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    @Override
    public void stop() {
    }

    private void validateLastItem() {
        if (this.lastItem != null && this.lastItem.isDisposed()) {
            this.lastItem = null;
        }
    }

    @Override
    public void refilter() {
        ScopeSetManager manager = ScopeState.getInstance().getScopeSetManager();
        ScopeSet set = manager.getActiveSet();
        EngineDescriptor[] engineDescriptors = this.parent.getEngineManager().getDescriptors();
        ISearchScope scope = null;
        int i = 0;
        while (i < engineDescriptors.length) {
            EngineDescriptor ed = engineDescriptors[i];
            if (ed.getEngineTypeId().equals("org.eclipse.help.ui.localSearch") && ed.getEngine() != null) {
                scope = ed.createSearchScope(set.getPreferenceStore());
            }
            ++i;
        }
        WorkingSet workingSet = null;
        LocalHelpScope localScope = (LocalHelpScope)scope;
        workingSet = localScope.getWorkingSet();
        this.treeViewer.resetFilters();
        if (workingSet != null) {
            WorkingSetScope helpScope = new WorkingSetScope(workingSet, set.getName());
            this.treeViewer.addFilter((ViewerFilter)new ScopeFilter((AbstractHelpScope)helpScope));
        }
        this.treeViewer.refresh();
    }

    private class ScopeFilter
    extends ViewerFilter {
        AbstractHelpScope scope;

        public ScopeFilter(AbstractHelpScope scope) {
            this.scope = scope;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IToc) {
                return ScopeUtils.showInTree((IToc)((IToc)element), (AbstractHelpScope)this.scope);
            }
            if (element instanceof ITopic) {
                return ScopeUtils.showInTree((ITopic)((ITopic)element), (AbstractHelpScope)this.scope);
            }
            if (element instanceof IIndexEntry) {
                return ScopeUtils.showInTree((IIndexEntry)((IIndexEntry)element), (AbstractHelpScope)this.scope);
            }
            if (element instanceof IIndexSee) {
                return ScopeUtils.showInTree((IIndexSee)((IIndexSee)element), (AbstractHelpScope)this.scope);
            }
            return true;
        }
    }

    public class ScopeObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof ScopeSetManager) {
                HyperlinkTreePart.this.refilter();
            }
        }
    }
}

