/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.notation.View;

public class DurationConstraintAutomaticRouter
extends ObliqueRouter {
    public DurationConstraintAutomaticRouter(View notationView) {
    }

    protected void resetEndPointsToEdge(Connection conn, PointList newLine) {
        if (newLine.size() < 2) {
            newLine.addPoint(0, 0);
            newLine.insertPoint(new Point(), 0);
        }
        PrecisionPoint sourceAnchorPoint = null;
        PrecisionPoint targetAnchorPoint = null;
        while (newLine.size() != 2) {
            newLine.removePoint(1);
        }
        PrecisionPoint sourceReference = this.getAnchorReference(conn.getTargetAnchor());
        sourceAnchorPoint = this.getAnchorLocation(conn.getSourceAnchor(), (Point)sourceReference);
        targetAnchorPoint = this.getAnchorLocation(conn.getTargetAnchor(), (Point)sourceAnchorPoint);
        Point midpoint = this.recomputeBenpointLocation(conn);
        newLine.addPoint(midpoint);
        newLine.setPoint(midpoint, 1);
        conn.translateToRelative((Translatable)sourceAnchorPoint);
        conn.translateToRelative((Translatable)targetAnchorPoint);
        newLine.setPoint((Point)new PrecisionPoint(sourceAnchorPoint.preciseX(), sourceAnchorPoint.preciseY()), 0);
        newLine.setPoint((Point)targetAnchorPoint, newLine.size() - 1);
    }

    public Point recomputeBenpointLocation(Connection conn) {
        PrecisionPoint a1 = new PrecisionPoint(conn.getSourceAnchor().getReferencePoint());
        PrecisionPoint a2 = new PrecisionPoint(conn.getTargetAnchor().getReferencePoint());
        PrecisionPoint a3 = new PrecisionPoint(conn.getSourceAnchor().getLocation((Point)a1));
        PrecisionPoint a4 = new PrecisionPoint(conn.getTargetAnchor().getLocation((Point)a2));
        conn.translateToRelative((Translatable)a3);
        conn.translateToRelative((Translatable)a4);
        return new PrecisionPoint(a4.preciseX() + this.computeOffset(a3.preciseX(), a4.preciseX()), a3.preciseY());
    }

    private double computeOffset(double x, double x2) {
        if (Math.abs(x - x2) > 20.0) {
            return 20.0 * Math.signum(x - x2);
        }
        return (x - x2) * 0.5;
    }

    private PrecisionPoint getAnchorLocation(ConnectionAnchor anchor, Point reference) {
        return new PrecisionPoint(anchor.getLocation(reference));
    }

    private PrecisionPoint getAnchorReference(ConnectionAnchor anchor) {
        return new PrecisionPoint(anchor.getReferencePoint());
    }
}

