/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class ExecutionSpecificationUtil {
    public static final int TOP_SPACING_HEIGHT = 5;

    private ExecutionSpecificationUtil() {
    }

    public static Rectangle calculateExecutionSpecificationCorrectLocation(LifelineEditPart lifeLineEditPart, Rectangle initialRectangle, EditPart editPartToSkip) {
        Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles = ExecutionSpecificationUtil.getRectangles(lifeLineEditPart);
        return ExecutionSpecificationUtil.calculateExecutionSpecificationCorrectLocation(lifeLineEditPart, executionSpecificationRectangles, initialRectangle, editPartToSkip);
    }

    public static Rectangle calculateExecutionSpecificationCorrectLocation(LifelineEditPart lifeLineEditPart, Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles, Rectangle initialRectangle, EditPart editPartToSkip) {
        return ExecutionSpecificationUtil.calculateExecutionSpecificationCorrectLocation(lifeLineEditPart, executionSpecificationRectangles, initialRectangle, Collections.singleton(editPartToSkip));
    }

    public static Rectangle calculateExecutionSpecificationCorrectLocation(LifelineEditPart lifeLineEditPart, Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles, Rectangle initialRectangle, Collection<EditPart> editPartsToSkip) {
        Rectangle result = new Rectangle(ExecutionSpecificationUtil.getInitialXForExecutionSpecification(lifeLineEditPart, initialRectangle), initialRectangle.y, initialRectangle.width, initialRectangle.height);
        for (Map.Entry<AbstractExecutionSpecificationEditPart, Rectangle> entry : executionSpecificationRectangles.entrySet()) {
            Rectangle currentRectangle = entry.getValue();
            if (editPartsToSkip != null && editPartsToSkip.contains((Object)entry.getKey()) || result.y <= currentRectangle.y || result.y >= currentRectangle.y + currentRectangle.height) continue;
            if (result.y < currentRectangle.y + 5) {
                result.y = currentRectangle.y + 5;
            }
            if (result.x >= currentRectangle.x + currentRectangle.width / 2) continue;
            result.x = currentRectangle.x + currentRectangle.width / 2;
        }
        return result;
    }

    public static CompoundCommand getExecutionSpecificationToMove(LifelineEditPart lifeLineEditPart, Rectangle initialRectangle, Rectangle modifiedRectangle, EditPart editPartToSkip) {
        Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles = ExecutionSpecificationUtil.getRectangles(lifeLineEditPart);
        return ExecutionSpecificationUtil.getExecutionSpecificationToMove(lifeLineEditPart, executionSpecificationRectangles, initialRectangle, modifiedRectangle, editPartToSkip);
    }

    public static CompoundCommand getExecutionSpecificationToMove(LifelineEditPart lifeLineEditPart, Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles, Rectangle initialRectangle, Rectangle modifiedRectangle, EditPart editPartToSkip) {
        int xPosition;
        CompoundCommand compoundCommand = new CompoundCommand("Edit Execution Specification positions");
        Map<AbstractExecutionSpecificationEditPart, Rectangle> initialRectangles = ExecutionSpecificationUtil.copyRectangles(executionSpecificationRectangles);
        int yBeginPosition = modifiedRectangle != null && initialRectangle.y > modifiedRectangle.y ? modifiedRectangle.y : initialRectangle.y;
        int yEndPosition = modifiedRectangle != null && initialRectangle.y + initialRectangle.height < modifiedRectangle.y + modifiedRectangle.height ? modifiedRectangle.y + modifiedRectangle.height : initialRectangle.y + initialRectangle.height;
        int n = xPosition = modifiedRectangle != null && initialRectangle.x > modifiedRectangle.x ? modifiedRectangle.x : initialRectangle.x;
        if (executionSpecificationRectangles.get(editPartToSkip) != null) {
            executionSpecificationRectangles.remove(editPartToSkip);
            if (modifiedRectangle != null) {
                executionSpecificationRectangles.put((AbstractExecutionSpecificationEditPart)editPartToSkip, modifiedRectangle);
            }
        }
        boolean hasChange = true;
        while (hasChange) {
            hasChange = false;
            Iterator<Map.Entry<AbstractExecutionSpecificationEditPart, Rectangle>> entries = executionSpecificationRectangles.entrySet().iterator();
            while (entries.hasNext() && !hasChange) {
                Rectangle calculatedRectangle;
                Map.Entry<AbstractExecutionSpecificationEditPart, Rectangle> currentEntry = entries.next();
                if (currentEntry.getKey() == editPartToSkip) continue;
                Rectangle currentRectangle = currentEntry.getValue();
                if (currentRectangle.x < xPosition || currentRectangle.y < yBeginPosition || currentRectangle.y > yEndPosition || currentRectangle.equals((Object)(calculatedRectangle = ExecutionSpecificationUtil.calculateExecutionSpecificationCorrectLocation(lifeLineEditPart, executionSpecificationRectangles, currentRectangle, (EditPart)currentEntry.getKey())))) continue;
                currentRectangle.setBounds(calculatedRectangle);
                if (yEndPosition < calculatedRectangle.y + calculatedRectangle.height) {
                    yEndPosition = calculatedRectangle.y + calculatedRectangle.height;
                }
                hasChange = true;
            }
        }
        for (Map.Entry<AbstractExecutionSpecificationEditPart, Rectangle> modifiedEditPartsEntry : executionSpecificationRectangles.entrySet()) {
            Rectangle modifiedCurrentRectangle;
            Rectangle initialCurrentRectangle;
            if (modifiedEditPartsEntry.getKey() == editPartToSkip || (initialCurrentRectangle = initialRectangles.get((Object)modifiedEditPartsEntry.getKey())).equals((Object)(modifiedCurrentRectangle = modifiedEditPartsEntry.getValue()))) continue;
            compoundCommand.add((Command)new ICommandProxy((ICommand)new SetResizeAndLocationCommand(lifeLineEditPart.getEditingDomain(), "Change Execution Specification bounds", (IAdaptable)modifiedEditPartsEntry.getKey(), modifiedCurrentRectangle)));
        }
        return compoundCommand;
    }

    public static Map<AbstractExecutionSpecificationEditPart, Rectangle> getRectangles(LifelineEditPart lifeLineEditPart) {
        return ExecutionSpecificationUtil.getRectangles(lifeLineEditPart, null);
    }

    public static Map<AbstractExecutionSpecificationEditPart, Rectangle> getRectangles(LifelineEditPart lifeLineEditPart, Collection<EditPart> editPartsToSkip) {
        HashMap<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles = new HashMap<AbstractExecutionSpecificationEditPart, Rectangle>();
        for (Object childEditPart : lifeLineEditPart.getChildren()) {
            Object view;
            if (!(childEditPart instanceof AbstractExecutionSpecificationEditPart) || editPartsToSkip != null && editPartsToSkip.contains(childEditPart) || !((view = ((AbstractExecutionSpecificationEditPart)((Object)childEditPart)).getModel()) instanceof Node)) continue;
            Bounds bounds = BoundForEditPart.getBounds((Node)view);
            executionSpecificationRectangles.put((AbstractExecutionSpecificationEditPart)((Object)childEditPart), new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight()));
        }
        return executionSpecificationRectangles;
    }

    private static Map<AbstractExecutionSpecificationEditPart, Rectangle> copyRectangles(Map<AbstractExecutionSpecificationEditPart, Rectangle> rectangles) {
        HashMap<AbstractExecutionSpecificationEditPart, Rectangle> copiedRectangles = new HashMap<AbstractExecutionSpecificationEditPart, Rectangle>();
        for (Map.Entry<AbstractExecutionSpecificationEditPart, Rectangle> entry : rectangles.entrySet()) {
            copiedRectangles.put(entry.getKey(), new Rectangle(entry.getValue()));
        }
        return copiedRectangles;
    }

    public static int getInitialXForExecutionSpecification(LifelineEditPart lifeLineEditPart, Rectangle executionSpecificationRectangle) {
        int result = 0;
        View lifeLineView = (View)lifeLineEditPart.getModel();
        if (lifeLineView instanceof Node) {
            int lifeLineWidth = BoundForEditPart.getWidthFromView((Node)lifeLineView);
            int executionSpecificationWidth = executionSpecificationRectangle != null && -1 != executionSpecificationRectangle.width ? executionSpecificationRectangle.width : AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH;
            result = lifeLineWidth / 2 - executionSpecificationWidth / 2;
        }
        return result;
    }

    public static Optional<ExecutionSpecification> getStartedExecution(OccurrenceSpecification occurrence) {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)occurrence);
        Predicate<EStructuralFeature.Setting> settingFilter = setting -> setting.getEStructuralFeature() == UMLPackage.Literals.EXECUTION_SPECIFICATION__START;
        return cache.getInverseReferences((EObject)occurrence).stream().filter(settingFilter).findFirst().map(EStructuralFeature.Setting::getEObject).map(ExecutionSpecification.class::cast);
    }
}

