/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.uml.profile.drafter.ProfileCatalog;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeNameToProfileSynchronizer {
    protected String qualifiedName;
    protected String profileName;
    protected String stereotypeName;
    protected Stereotype stereotype;
    protected ProfileCatalog profileCatalog;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public StereotypeNameToProfileSynchronizer(ProfileCatalog profileCatalog) {
        this.profileCatalog = profileCatalog;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.doSetQualifiedName(qualifiedName);
    }

    protected void doSetQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        this.firePropertyChange("profileName", this.qualifiedName, this.qualifiedName);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.doSetProfileName(profileName);
        this.checkStereotype();
    }

    protected void doSetProfileName(String profileName) {
        this.profileName = profileName;
        this.firePropertyChange("profileName", this.profileName, this.profileName);
    }

    public String getStereotypeName() {
        return this.stereotypeName;
    }

    public void setStereotypeName(String stereotypeName) {
        this.doSetStereotypeName(stereotypeName);
        this.checkStereotype();
    }

    protected void doSetStereotypeName(String stereotypeName) {
        this.stereotypeName = stereotypeName;
        this.firePropertyChange("stereotypeName", this.stereotypeName, this.stereotypeName);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.doSetStereotype(stereotype);
        this.doSetProfileName(stereotype.getProfile().getName());
        this.doSetStereotypeName(stereotype.getName());
    }

    protected void doSetStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
        this.firePropertyChange("stereotype", this.stereotype, this.stereotype);
    }

    protected void checkStereotype() {
        if (this.stereotype != null && this.stereotypeName == this.stereotype.getName() && this.profileName == this.stereotype.getProfile().getName()) {
            return;
        }
        try {
            Stereotype stereotype = this.profileCatalog.lookupStereotype(this.profileName, this.stereotypeName);
            this.doSetStereotype(stereotype);
        }
        catch (NotFoundException e) {
            this.doSetStereotype(null);
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

