/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.core.composite;

import org.eclipse.core.resources.IResource;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIResourceComposite<T extends IResource>
extends AbstractCellEditorComposite<T> {
    private final Button button;
    private Text text = null;
    private final Composite parentControl;

    public AbstractIResourceComposite(Composite parent) {
        this(parent, 0);
    }

    public AbstractIResourceComposite(Composite parent, int style) {
        super(parent);
        this.parentControl = parent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData data = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIResourceComposite.this.browseResource();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == AbstractIResourceComposite.this.getParentControl().getShell() && event.widget != AbstractIResourceComposite.this.getButton() && event.widget != AbstractIResourceComposite.this.getText()) {
                    AbstractIResourceComposite.this.fireCommit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    AbstractIResourceComposite.this.fireCommit();
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    AbstractIResourceComposite.this.close();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractIResourceComposite.this.fireChanged();
            }
        });
        this.text.forceFocus();
    }

    protected Button getButton() {
        return this.button;
    }

    protected Text getText() {
        return this.text;
    }

    protected void commit() {
        this.fireCommit();
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }

    @Override
    public void setValue(IResource value) {
        if (value != null) {
            this.text.setText(value.getFullPath().toString());
        } else {
            this.text.setText("");
        }
    }

    @Override
    public abstract T getValue();

    protected abstract void browseResource();
}

