/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.osgi.service.prefs.BackingStoreException;

public class ArchitectureDomainPreferences
implements Cloneable {
    public static final String ADDED_MODELS = "addedModels";
    public static final String EXCLUDED_CONTEXTS = "excludedContexts";
    public static final String DEFAULT_CONTEXT = "defaultContext";
    static final String DEFAULT_DEFAULT_CONTEXT_ID = TypeContext.getDefaultContextId();
    private List<String> addedModelURIs = new ArrayList<String>();
    private Set<String> excludedContextIds = new HashSet<String>();
    private String defaultContextId = DEFAULT_DEFAULT_CONTEXT_ID;

    public ArchitectureDomainPreferences() {
        this.read();
    }

    private static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.architecture");
    }

    public void read() {
        String value = ArchitectureDomainPreferences.getPreferences().get(ADDED_MODELS, "");
        this.addedModelURIs = value.equals("") ? new ArrayList() : Arrays.asList(value.split(" "));
        value = ArchitectureDomainPreferences.getPreferences().get(EXCLUDED_CONTEXTS, "");
        this.excludedContextIds = value.equals("") ? new HashSet<String>() : new HashSet<String>(Arrays.asList(value.split(",")));
        this.defaultContextId = value = ArchitectureDomainPreferences.getPreferences().get(DEFAULT_CONTEXT, DEFAULT_DEFAULT_CONTEXT_ID);
    }

    public void write() {
        ArchitectureDomainPreferences.getPreferences().put(ADDED_MODELS, String.join((CharSequence)" ", this.addedModelURIs));
        ArchitectureDomainPreferences.getPreferences().put(EXCLUDED_CONTEXTS, String.join((CharSequence)",", this.excludedContextIds));
        ArchitectureDomainPreferences.getPreferences().put(DEFAULT_CONTEXT, this.defaultContextId);
        try {
            ArchitectureDomainPreferences.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void reset() {
        this.addedModelURIs.clear();
        this.excludedContextIds.clear();
        this.defaultContextId = DEFAULT_DEFAULT_CONTEXT_ID;
    }

    static void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        ArchitectureDomainPreferences.getPreferences().addPreferenceChangeListener(listener);
    }

    public List<String> getAddedModelURIs() {
        return this.addedModelURIs;
    }

    public Set<String> getExcludedContextIds() {
        return this.excludedContextIds;
    }

    public String getDefaultContextId() {
        return this.defaultContextId;
    }

    public void setDefaultContextId(String defaultContextId) {
        this.defaultContextId = defaultContextId;
    }

    public ArchitectureDomainPreferences clone() {
        ArchitectureDomainPreferences clone = new ArchitectureDomainPreferences();
        clone.addedModelURIs = new ArrayList<String>(this.getAddedModelURIs());
        clone.excludedContextIds = new HashSet<String>(this.getExcludedContextIds());
        clone.setDefaultContextId(this.getDefaultContextId());
        return clone;
    }
}

