/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewSettings {
    private static int DEFAULT_SORT_COLUMN = 2;
    private static int DEFAULT_SORT_DIRECTION = 128;
    private static Integer[] DEFAULT_COLUMN_WIDTHS = new Integer[]{0, -30, -25, -30, -15};
    private static int DEFAULT_COLUMN_WIDTH = 30;
    private List<Integer> columnWidths;
    private int sortColumn;
    private int sortDirection;

    public ViewSettings(IMemento memento) {
        if (memento != null) {
            this.load(memento);
        } else {
            this.initDefaults();
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int index) {
        this.sortColumn = index;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int direction) {
        this.sortDirection = direction == 1024 ? 1024 : 128;
    }

    public int getColumnWidth(int index) {
        int result = DEFAULT_COLUMN_WIDTH;
        if (index >= 0 && index < this.columnWidths.size()) {
            result = this.columnWidths.get(index);
        }
        return result;
    }

    public void setColumnWidth(int index, int weight) {
        if (index >= 0) {
            if (index < this.columnWidths.size()) {
                this.columnWidths.set(index, weight);
            } else {
                if (index > this.columnWidths.size()) {
                    this.columnWidths.addAll(Collections.nCopies(index - this.columnWidths.size(), DEFAULT_COLUMN_WIDTH));
                }
                this.columnWidths.add(weight);
            }
        }
    }

    public void save(IMemento memento) {
        this.setIntegerList(memento, "columnWidths", this.columnWidths);
        memento.putInteger("sortColumn", this.sortColumn);
        memento.putInteger("sortDirection", this.sortDirection);
    }

    private void load(IMemento memento) {
        this.columnWidths = this.getIntegerList(memento, "columnWidths", DEFAULT_COLUMN_WIDTHS);
        this.sortColumn = this.getInt(memento, "sortColumn", DEFAULT_SORT_COLUMN);
        this.sortDirection = this.getInt(memento, "sortDirection", DEFAULT_SORT_DIRECTION);
    }

    private void initDefaults() {
        this.columnWidths = Lists.newArrayList((Object[])DEFAULT_COLUMN_WIDTHS);
        this.sortColumn = DEFAULT_SORT_COLUMN;
        this.sortDirection = DEFAULT_SORT_DIRECTION;
    }

    private int getInt(IMemento memento, String key, int defaultValue) {
        Integer value = memento.getInteger(key);
        return value == null ? defaultValue : value;
    }

    private List<Integer> getIntegerList(IMemento memento, String key, Integer[] defaultValue) {
        String stringValue = memento.getString(key);
        ArrayList result = stringValue == null ? Lists.newArrayList((Object[])defaultValue) : Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)stringValue), (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return "".equals(input) ? DEFAULT_COLUMN_WIDTH : Integer.valueOf(input);
            }
        }));
        return result;
    }

    private void setIntegerList(IMemento memento, String key, Iterable<Integer> values) {
        memento.putString(key, Joiner.on((char)',').join(values));
    }
}

