/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.xtext;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.Activator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.properties.widgets.LanguageBodyEditor;
import org.eclipse.papyrus.uml.properties.xtext.UndoRedoStack;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextXtextAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class XtextLanguageEditor
implements LanguageBodyEditor,
ContextElementAdapter.IContextElementProvider {
    protected StyledText textControl;
    UndoRedoStack<ExtendedModifyEvent> undoRedoStack;
    protected boolean isUndo;
    protected boolean isRedo;
    private DefaultXtextDirectEditorConfiguration configuration;
    private StyledTextXtextAdapter xtextAdapter;
    protected EObject currentEObj;
    private final ContextElementAdapter contextElementAdapter = new ContextElementAdapter((ContextElementAdapter.IContextElementProvider)this);
    private String language = "";

    public void createWidget(Composite parent, int style) {
        this.undoRedoStack = new UndoRedoStack();
        this.createTextControl(parent);
    }

    protected void createTextControl(Composite parent) {
        this.textControl = new StyledText(parent, 2626);
        this.textControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                IParser parser = XtextLanguageEditor.this.getParser();
                if (XtextLanguageEditor.this.xtextAdapter == null) {
                    return;
                }
                if (XtextLanguageEditor.this.xtextAdapter.getCompletionProposalAdapter().delayedIsPopupOpen()) {
                    return;
                }
                if (parser != null && !parser.getEditString(null, 0).equals(XtextLanguageEditor.this.textControl.getText())) {
                    ICommand command = parser.getParseCommand((IAdaptable)new EObjectAdapter(XtextLanguageEditor.this.getEObject()), XtextLanguageEditor.this.textControl.getText(), 0);
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)XtextLanguageEditor.this.getEObject());
                    if (domain == null) {
                        ResourceSet rs = NestedEditingDialogContext.getInstance().getResourceSet();
                        domain = TransactionUtil.getEditingDomain((ResourceSet)rs);
                    }
                    if (domain != null) {
                        domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(command));
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.textControl.setAlwaysShowScrollBars(false);
        this.textControl.setLayout((Layout)new GridLayout());
        this.textControl.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (XtextLanguageEditor.this.isUndo) {
                    XtextLanguageEditor.this.undoRedoStack.pushRedo(event);
                } else {
                    XtextLanguageEditor.this.undoRedoStack.pushUndo(event);
                    if (!XtextLanguageEditor.this.isRedo) {
                        XtextLanguageEditor.this.undoRedoStack.clearRedo();
                    }
                }
            }
        });
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isAlt;
                boolean isCtrl = (e.stateMask & 0x40000) > 0;
                boolean bl = isAlt = (e.stateMask & 0x10000) > 0;
                if (isCtrl && !isAlt) {
                    boolean isShift;
                    boolean bl2 = isShift = (e.stateMask & 0x20000) > 0;
                    if (e.keyCode == 122) {
                        if (isShift) {
                            XtextLanguageEditor.this.redo();
                        } else {
                            XtextLanguageEditor.this.undo();
                        }
                    }
                }
            }
        });
    }

    public Control getTextControl() {
        return this.textControl;
    }

    protected void undo() {
        if (this.undoRedoStack.hasUndo()) {
            this.isUndo = true;
            this.revertEvent(this.undoRedoStack.popUndo());
            this.isUndo = false;
        }
    }

    protected void redo() {
        if (this.undoRedoStack.hasRedo()) {
            this.isRedo = true;
            this.revertEvent(this.undoRedoStack.popRedo());
            this.isRedo = false;
        }
    }

    protected void revertEvent(ExtendedModifyEvent event) {
        this.textControl.replaceTextRange(event.start, event.length, event.replacedText);
        this.textControl.setSelectionRange(event.start, event.replacedText.length());
    }

    protected IParser getParser() {
        EObject semanticElement = this.getEObject();
        if (this.configuration != null && semanticElement != null) {
            return this.configuration.createParser(semanticElement);
        }
        return null;
    }

    protected void updateXtextAdapters(Control styledText) {
        Object oldObjectToEdit = this.configuration != null ? this.configuration.getObjectToEdit() : null;
        DefaultXtextDirectEditorConfiguration newConfiguration = this.getConfigurationFromSelection();
        if (newConfiguration != null && newConfiguration != this.configuration) {
            if (this.xtextAdapter != null) {
                this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
            }
            this.configuration = newConfiguration;
            this.xtextAdapter = new StyledTextXtextAdapter(this.configuration.getInjector());
            EObject semanticElement = this.getEObject();
            if (semanticElement != null) {
                newConfiguration.preEditAction((Object)semanticElement);
            }
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)this.contextElementAdapter);
            this.xtextAdapter.adapt((StyledText)styledText);
        }
        if (this.configuration != null && this.configuration.getObjectToEdit() != oldObjectToEdit) {
            Object semanticObject;
            ContextElementAdapter.IContextElementProvider provider = this.configuration.getContextProvider();
            if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit && this.xtextAdapter != null) {
                ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(this.xtextAdapter.getFakeResourceContext().getFakeResource());
            }
            if ((semanticObject = this.configuration.getObjectToEdit()) instanceof EObject) {
                this.currentEObj = (EObject)semanticObject;
            }
        }
    }

    protected DefaultXtextDirectEditorConfiguration getConfigurationFromSelection() {
        EObject semanticElement = this.getEObject();
        if (semanticElement != null) {
            IDirectEditorConfiguration configuration;
            String semanticClassName;
            String key;
            String languagePreferred = this.language;
            if (!languagePreferred.isEmpty()) {
                IDirectEditorConfiguration configuration2 = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)semanticElement);
                if (configuration2 instanceof DefaultXtextDirectEditorConfiguration) {
                    DefaultXtextDirectEditorConfiguration xtextConfiguration = (DefaultXtextDirectEditorConfiguration)configuration2;
                    xtextConfiguration.preEditAction((Object)semanticElement);
                    return xtextConfiguration;
                }
                return null;
            }
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            languagePreferred = store.getString(key = "papyrus.directeditor." + (semanticClassName = semanticElement.eClass().getInstanceClassName()));
            if (languagePreferred != null && !languagePreferred.equals("") && (configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)semanticElement)) instanceof DefaultXtextDirectEditorConfiguration) {
                DefaultXtextDirectEditorConfiguration xtextConfiguration = (DefaultXtextDirectEditorConfiguration)configuration;
                xtextConfiguration.preEditAction((Object)semanticElement);
                return xtextConfiguration;
            }
        }
        return null;
    }

    public EObject getContextObject() {
        return this.getEObject();
    }

    public void setInput(String value) {
        if (value != null) {
            this.textControl.setText(value);
            this.undoRedoStack.clearUndo();
            this.undoRedoStack.clearRedo();
        }
    }

    public void dispose() {
        if (this.textControl != null) {
            this.textControl.dispose();
        }
        if (this.xtextAdapter != null) {
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
            this.xtextAdapter.dispose();
            this.xtextAdapter = null;
        }
    }

    public void addChangeListener(Listener listener) {
    }

    public void removeChangeListener(Listener listener) {
    }

    public String getValue() {
        return null;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public void setContext(ModelElement context) {
        if (context instanceof UMLModelElement) {
            this.currentEObj = ((UMLModelElement)context).getSource();
            this.updateXtextAdapters((Control)this.textControl);
        }
    }

    protected EObject getEObject() {
        return this.currentEObj;
    }

    public void setLanguage(String language) {
        this.language = this.language == null ? "" : language;
    }

    public String getLanguage() {
        return this.language != null ? this.language : "";
    }
}

