/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.PlatformUIUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class StringEditorWithCompletionWrapper
implements ISetPapyrusConverter {
    private static final String CONTENT_ASSIST_COMMAND_ID = "org.eclipse.ui.edit.text.contentAssist.proposals";
    public IPapyrusConverter parser;
    private boolean delayedIsOpen = false;
    private TextViewer textViewer;
    private ContentAssistant assistant;
    private IContentAssistProcessor processor;

    public StringEditorWithCompletionWrapper(Composite parent, IPapyrusConverter parser) {
        this.setPapyrusConverter(parser);
        this.buildControls(parent, 0);
    }

    public StringEditorWithCompletionWrapper(Composite parent, int style, IPapyrusConverter parser) {
        this.setPapyrusConverter(parser);
        this.buildControls(parent, style);
    }

    public StringEditorWithCompletionWrapper(Composite parent, int style) {
        this.buildControls(parent, style);
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public StyledText getTextWidget() {
        if (this.textViewer != null) {
            return this.textViewer.getTextWidget();
        }
        return null;
    }

    public boolean isContentAssistOpened() {
        return this.delayedIsOpen;
    }

    private void buildControls(Composite parent, int style) {
        this.textViewer = new TextViewer(parent, 0x204 | style);
        this.textViewer.setDocument((IDocument)new Document());
        this.assistant = new ContentAssistant();
        if (this.parser != null) {
            this.processor = this.parser.getCompletionProcessor(null);
            this.assistant.setContentAssistProcessor(this.processor, "__dftl_partition_content_type");
        }
        this.assistant.setSorter(new ICompletionProposalSorter(){

            public int compare(ICompletionProposal p1, ICompletionProposal p2) {
                return p1.getDisplayString().compareTo(p2.getDisplayString());
            }
        });
        this.assistant.install((ITextViewer)this.textViewer);
        this.assistant.addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StringEditorWithCompletionWrapper.this.delayedIsOpen = true;
                    }
                });
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StringEditorWithCompletionWrapper.this.delayedIsOpen = false;
                    }
                });
            }
        });
        PlatformUIUtils.handleCommand(this.textViewer.getControl(), CONTENT_ASSIST_COMMAND_ID, "CTRL+SPACE", () -> ((ContentAssistant)this.assistant).showPossibleCompletions());
    }

    @Override
    public void setPapyrusConverter(IPapyrusConverter parser) {
        this.parser = parser;
        if (parser != null && this.assistant != null && this.processor == null) {
            this.processor = parser.getCompletionProcessor(null);
            this.assistant.setContentAssistProcessor(this.processor, "__dftl_partition_content_type");
        }
    }
}

