/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CompositeContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IDependableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IFlattenableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FlatFilteredContentProvider
implements IAdaptableContentProvider,
ICommitListener,
IGraphicalContentProvider,
IStaticContentProvider,
IHierarchicContentProvider,
IFlattenableContentProvider,
IRevealSemanticElement,
IDependableContentProvider {
    protected boolean sorted = true;
    protected ITreeContentProvider provider;
    protected ToolItem sortButton;
    protected static final String DIALOG_SETTINGS_KEY = FlatFilteredContentProvider.class.getName();
    protected static final String SORT_SETTINGS_KEY = "sort";
    protected static final String ICONS_ALPHA_SORT = "/icons/sort.gif";
    private StructuredViewer viewer;

    public FlatFilteredContentProvider() {
        this.initializeDialogsSettings();
    }

    public FlatFilteredContentProvider(IHierarchicContentProvider provider) {
        this.provider = provider;
        this.initializeDialogsSettings();
    }

    protected void initializeDialogsSettings() {
        this.setAlphaSorted(this.getDialogSettings().getBoolean(SORT_SETTINGS_KEY));
    }

    @Override
    public void createAfter(Composite parent) {
        if (this.provider instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)this.provider).createAfter(parent);
        }
    }

    @Override
    public void createViewerToolbar(Composite parent) {
        this.createSortButton(parent);
    }

    protected void createSortButton(Composite parent) {
        this.initializeDialogsSettings();
        ToolBar Toolbar = new ToolBar(parent, 0);
        this.sortButton = new ToolItem(Toolbar, 32);
        this.sortButton.setImage(Activator.getDefault().getImage(ICONS_ALPHA_SORT));
        this.sortButton.setToolTipText(Messages.FlatFilteredContentProvider_sortButtonTooltip);
        this.sortButton.setSelection(this.sorted);
        this.sortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FlatFilteredContentProvider.this.setAlphaSorted(!FlatFilteredContentProvider.this.sorted);
                FlatFilteredContentProvider.this.getDialogSettings().put(FlatFilteredContentProvider.SORT_SETTINGS_KEY, FlatFilteredContentProvider.this.sorted);
                FlatFilteredContentProvider.this.sortButton.setSelection(FlatFilteredContentProvider.this.sorted);
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = this.provider.getElements(inputElement);
        HashSet<Object> list = new HashSet<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.isValidValue(object)) {
                list.add(object);
            }
            list.addAll(Arrays.asList(this.getAllChildren(object, new HashSet<Object>())));
            ++n2;
        }
        return list.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    protected Object[] getAllChildren(Object parentElement, Set<Object> visitedElements) {
        HashSet<Object> list = new HashSet<Object>();
        Object[] children = this.provider.getChildren(parentElement);
        if (children != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                boolean visited = false;
                if (visitedElements.contains(children[i])) {
                    visited = true;
                } else {
                    visitedElements.add(children[i]);
                }
                if (!visited) {
                    EObject eObject = (EObject)PlatformHelper.getAdapter((Object)children[i], EObject.class);
                    if (eObject != null && !eObject.equals(children[i]) && visitedElements.contains(eObject)) {
                        visited = true;
                    } else {
                        visitedElements.add(eObject);
                    }
                }
                if (!visited && this.isValidValue(children[i])) {
                    list.add(children[i]);
                }
                if (!visited) {
                    list.addAll(Arrays.asList(this.getAllChildren(children[i], visitedElements)));
                }
                ++i;
            }
        }
        return list.toArray();
    }

    public void dispose() {
        this.provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public boolean isValidValue(Object element) {
        boolean isValidValue = true;
        if (this.provider instanceof IHierarchicContentProvider) {
            isValidValue = ((IHierarchicContentProvider)this.provider).isValidValue(element);
        }
        return isValidValue;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    @Override
    public void setFlat(boolean isFlat) {
        if (this.provider instanceof IFlattenableContentProvider) {
            ((IFlattenableContentProvider)this.provider).setFlat(isFlat);
        }
    }

    @Override
    public Object[] getElements() {
        if (this.provider instanceof IStaticContentProvider) {
            return ((IStaticContentProvider)this.provider).getElements();
        }
        return this.getElements(null);
    }

    @Override
    public void revealSemanticElement(List<?> elementList) {
        if (this.provider instanceof IRevealSemanticElement) {
            ((IRevealSemanticElement)this.provider).revealSemanticElement(elementList);
        } else if (this.provider instanceof CompositeContentProvider && ((CompositeContentProvider)this.provider).getContentProviders() != null) {
            for (ITreeContentProvider contentProvider : ((CompositeContentProvider)this.provider).getContentProviders()) {
                if (!(contentProvider instanceof IRevealSemanticElement)) continue;
                ((IRevealSemanticElement)contentProvider).revealSemanticElement(elementList);
            }
        }
    }

    @Override
    public void createBefore(Composite parent) {
        if (this.provider instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)this.provider).createBefore(parent);
        }
    }

    @Override
    public boolean isFlat() {
        return true;
    }

    @Override
    public void commit(AbstractEditor editor) {
        if (this.provider instanceof ICommitListener) {
            ((ICommitListener)this.provider).commit(editor);
        }
    }

    @Override
    public Object getAdaptedValue(Object containerElement) {
        if (this.provider instanceof IAdaptableContentProvider) {
            return ((IAdaptableContentProvider)this.provider).getAdaptedValue(containerElement);
        }
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settings;
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        return this.provider;
    }

    @Override
    public void setContentProvider(ITreeContentProvider provider) {
        this.provider = provider;
    }

    public void setAlphaSorted(boolean sorted) {
        this.sorted = sorted;
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            if (sorted) {
                this.viewer.setComparator(new ViewerComparator());
            } else {
                this.viewer.setComparator(null);
            }
            this.viewer.refresh();
        }
    }
}

