/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.internal.Schedulable;

public class Scheduler {
    protected int maxThreads;

    public Scheduler(int maxThreads) {
        this.maxThreads = Math.max(1, maxThreads);
    }

    public void schedule(IProgressMonitor monitor, List<? extends Schedulable> tasks) {
        LinkedList<? extends Schedulable> remainingTasks = new LinkedList<Schedulable>(tasks);
        LinkedList<Schedulable> runningTasks = new LinkedList<Schedulable>();
        while (!remainingTasks.isEmpty()) {
            if (monitor.isCanceled()) {
                monitor.subTask("Canceling remaining jobs...");
                for (Schedulable task : runningTasks) {
                    task.cancel();
                }
                remainingTasks.clear();
            }
            while (runningTasks.size() < this.maxThreads && !remainingTasks.isEmpty()) {
                Schedulable task;
                task = (Schedulable)remainingTasks.remove(0);
                task.start();
                runningTasks.add(task);
            }
            if (!runningTasks.isEmpty()) {
                String waitFor = ((Schedulable)runningTasks.get(0)).getName();
                monitor.subTask("Waiting for Import " + waitFor + " to complete...");
            }
            boolean canContinue = false;
            Iterator iterator = runningTasks.iterator();
            while (iterator.hasNext()) {
                Schedulable runningTask = (Schedulable)iterator.next();
                if (!runningTask.isComplete()) continue;
                canContinue = true;
                iterator.remove();
                monitor.worked(1);
            }
            if (canContinue) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        this.wait(runningTasks, monitor);
    }

    protected void wait(List<Schedulable> tasks, IProgressMonitor monitor) {
        LinkedList<Schedulable> runningTasks = new LinkedList<Schedulable>(tasks);
        while (!runningTasks.isEmpty()) {
            if (monitor.isCanceled()) {
                monitor.subTask("Canceling remaining jobs...");
                for (Schedulable task : runningTasks) {
                    task.cancel();
                }
            }
            Iterator iterator = runningTasks.iterator();
            while (iterator.hasNext()) {
                Schedulable task = (Schedulable)iterator.next();
                if (!task.isComplete()) continue;
                iterator.remove();
                monitor.worked(1);
            }
            if (runningTasks.isEmpty()) continue;
            String waitFor = ((Schedulable)runningTasks.get(0)).getName();
            monitor.subTask("Waiting for " + waitFor + " to complete...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Activator.log.error((Throwable)ex);
                return;
            }
        }
    }
}

