/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.advice;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml16.service.types.command.UpdateNestedPathConnectorEnd;
import org.eclipse.papyrus.sysml16.service.types.util.ConnectorUtil;
import org.eclipse.papyrus.sysml16.service.types.util.UMLConnectorUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ConnectableElement;

public class ConnectorCreationEditHelperAdvice
extends AbstractEditHelperAdvice {
    private UMLConnectorUtils utils = new UMLConnectorUtils();

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        EObject source = request.getSource();
        EObject target = request.getTarget();
        EObject container = request.getContainer();
        View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
        View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
        if (Arrays.asList(request.getElementType().getAllSuperTypes()).contains(UMLElementTypes.CONNECTOR) && source != null && target != null && container != null && (((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.Block")).getMatcher().matches(container) || ((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.ConstraintBlock")).getMatcher().matches(container))) {
            if (ConnectorUtil.isCrossingEncapsulation(sourceView, targetView) || ConnectorUtil.isCrossingEncapsulation(targetView, sourceView)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (this.canCreate(source, target, sourceView, targetView)) {
                request.setParameter("UML_STRICT", (Object)false);
            }
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterCreateRelationshipCommand(CreateRelationshipRequest request) {
        ICommand defaultCommand = super.getAfterCreateRelationshipCommand(request);
        EObject container = request.getContainer();
        View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
        View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
        if (Arrays.asList(request.getElementType().getAllSuperTypes()).contains(UMLElementTypes.CONNECTOR) && request.getSource() != null && request.getTarget() != null && container != null && (((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.Block")).getMatcher().matches(container) || ((ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.ConstraintBlock")).getMatcher().matches(container))) {
            UpdateNestedPathConnectorEnd updateNestedPathConnectorEndSource = new UpdateNestedPathConnectorEnd("UpdateNestedPathConnectorEnd Source", (EObject)sourceView, (IEditCommandRequest)request, true);
            defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)updateNestedPathConnectorEndSource);
            UpdateNestedPathConnectorEnd updateNestedPathConnectorEndTarget = new UpdateNestedPathConnectorEnd("UpdateNestedPathConnectorEnd Target", (EObject)targetView, (IEditCommandRequest)request, false);
            defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)updateNestedPathConnectorEndTarget);
        }
        return defaultCommand;
    }

    private boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ConnectableElement)) {
            return false;
        }
        if (target != null && !(target instanceof ConnectableElement)) {
            return false;
        }
        if (sourceView != null && targetView != null) {
            if (sourceView.getChildren().contains((Object)targetView) || targetView.getChildren().contains((Object)sourceView)) {
                return false;
            }
            if (this.utils.getStructureContainers(sourceView).contains(targetView) || this.utils.getStructureContainers(targetView).contains(sourceView)) {
                return false;
            }
        }
        return true;
    }
}

