/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.modelelement;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EObjectDirectEditingValueFactory;
import org.eclipse.swt.widgets.Control;

public class EObjectStructuredValueFactory
extends EObjectDirectEditingValueFactory {
    public EObjectStructuredValueFactory(EReference referenceIn) {
        super(referenceIn);
    }

    @Override
    protected Object doCreateObject(Control widget, Object context) {
        EObject instance = this.referenceIn.isContainment() ? this.createStructuredObject(widget) : this.createObjectInDifferentContainer(widget);
        return this.createObject(widget, context, instance);
    }

    protected EObject createStructuredObject(Control widget) {
        EClass eClass = this.chooseEClass(widget);
        if (eClass == null) {
            return null;
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.createStructure(instance);
        return instance;
    }

    private void createStructure(EObject eObject) {
        if (eObject != null) {
            EList eStructuralFeatures = eObject.eClass().getEStructuralFeatures();
            for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
                if (!(eStructuralFeature instanceof EReference)) continue;
                Object eGet = eObject.eGet(eStructuralFeature);
                if (eGet == null && eStructuralFeature.getEType() instanceof EClass) {
                    EClass new_name = (EClass)eStructuralFeature.getEType();
                    EObject create = new_name.getEPackage().getEFactoryInstance().create(new_name);
                    this.setValue(eObject, create, eGet, eStructuralFeature);
                    eGet = eObject.eGet(eStructuralFeature);
                }
                if (!(eGet instanceof EObject)) continue;
                this.createStructure((EObject)eGet);
            }
        }
    }

    protected void setValue(EObject eObject, Object value, Object oldValue, EStructuralFeature eStructuralFeature) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        Command command = this.getSetCommand(eObject, value, oldValue, eStructuralFeature, (EditingDomain)editingDomain);
        command.execute();
    }

    protected Command getSetCommand(EObject eObject, Object value, Object oldValue, EStructuralFeature eStructuralFeature, EditingDomain domain) {
        CompoundCommand cc = new CompoundCommand("Edit value");
        if (oldValue instanceof EObject && eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) {
            cc.append(DeleteCommand.create((EditingDomain)domain, (Object)oldValue));
        }
        cc.append((Command)new SetCommand(domain, eObject, eStructuralFeature, value));
        return cc;
    }
}

