/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;

public class NestedProjectsProblemsModel {
    private boolean neverRan = true;
    private final Set<IResource> dirty = new LinkedHashSet<IResource>();
    private final Map<IResource, Integer> cache = new HashMap<IResource, Integer>();
    private final Set<IResource> modifiedSeveritySinceLastRun = new LinkedHashSet<IResource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        LinkedHashSet<IResource> localDirty;
        this.modifiedSeveritySinceLastRun.clear();
        Set<IResource> set = this.dirty;
        synchronized (set) {
            localDirty = new LinkedHashSet<IResource>(this.dirty);
            this.dirty.clear();
        }
        this.removeFromCache(localDirty);
        this.modifiedSeveritySinceLastRun.addAll(localDirty);
        try {
            IMarker[] iMarkerArray = WorkbenchNavigatorPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int severity;
                IMarker marker = iMarkerArray[n2];
                IResource resource = marker.getResource();
                if (resource != null && (this.neverRan || localDirty.contains(resource)) && (severity = marker.getAttribute("severity", -1)) >= 0) {
                    this.propagateSeverityToCache(resource, severity);
                }
                ++n2;
            }
            this.neverRan = false;
        }
        catch (CoreException e) {
            WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            throw new RuntimeException(e);
        }
        catch (CancellationException cancellationException) {}
    }

    private void removeFromCache(Set<IResource> toRemove) {
        LinkedHashSet<IContainer> dirtyLeafContainers = new LinkedHashSet<IContainer>();
        for (IResource resource : toRemove) {
            IPath currentLocation;
            IContainer currentContainer;
            IContainer iContainer = currentContainer = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
            if (currentContainer == null || (currentLocation = currentContainer.getLocation()) == null) continue;
            dirtyLeafContainers.removeIf(leafContainer -> {
                IPath leafLocation = leafContainer.getLocation();
                return leafLocation != null && leafLocation.isPrefixOf(currentLocation);
            });
            if (dirtyLeafContainers.stream().noneMatch(leafContainer -> {
                IPath leafLocation = leafContainer.getLocation();
                return leafLocation != null && currentLocation.isPrefixOf(leafLocation);
            })) {
                dirtyLeafContainers.add(currentContainer);
            }
            if (resource.getType() == 1) {
                this.cache.remove(resource);
                this.modifiedSeveritySinceLastRun.add(resource);
            }
            IContainer container = currentContainer;
            while (container != null && this.cache.containsKey(container)) {
                this.cache.remove(container);
                this.modifiedSeveritySinceLastRun.add((IResource)container);
                container = this.getParentInView((IResource)container);
            }
        }
        dirtyLeafContainers.forEach(leafContainer -> {
            IContainer container = leafContainer;
            while (container != null) {
                int severity = this.getMaxChildrenSeverityInCache(container);
                if (severity >= 0) {
                    this.propagateSeverityToCache((IResource)container, severity);
                }
                container = this.getParentInView((IResource)container);
            }
        });
    }

    private int getMaxChildrenSeverityInCache(IContainer container) {
        if (!container.isAccessible()) {
            return -1;
        }
        LinkedHashSet<Object> children = new LinkedHashSet<Object>();
        try {
            children.addAll(Arrays.asList(container.members()));
        }
        catch (CoreException ex) {
            WorkbenchNavigatorPlugin.log("Cannot access members", WorkbenchNavigatorPlugin.createErrorStatus(ex.getMessage(), ex));
        }
        children.addAll(Arrays.asList(NestedProjectManager.getInstance().getDirectChildrenProjects(container)));
        int severity = -1;
        for (IResource iResource : children) {
            Integer cachedSeverity = this.cache.get(iResource);
            if (cachedSeverity == null || cachedSeverity <= severity || (severity = cachedSeverity.intValue()) < 2) continue;
            return severity;
        }
        return severity;
    }

    private void propagateSeverityToCache(IResource resource, int severity) {
        while (resource != null) {
            Integer cachedSeverity = this.cache.get(resource);
            if (cachedSeverity == null || cachedSeverity < severity) {
                this.cache.put(resource, severity);
                this.modifiedSeveritySinceLastRun.add(resource);
                resource = this.getParentInView(resource);
                continue;
            }
            resource = null;
        }
    }

    private IContainer getParentInView(IResource resource) {
        if (resource.getType() == 4) {
            return NestedProjectManager.getInstance().getMostDirectOpenContainer((IProject)resource);
        }
        return resource.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(IResource resource) {
        Set<IResource> set = this.dirty;
        synchronized (set) {
            this.dirty.add(resource);
        }
    }

    public Collection<IResource> getResourcesWithModifiedSeverity() {
        return Collections.unmodifiableSet(this.modifiedSeveritySinceLastRun);
    }

    public Integer getMaxSeverityIncludingNestedProjects(IResource resource) {
        return this.cache.getOrDefault(resource, -1);
    }

    public boolean isDirty() {
        return this.neverRan || !this.dirty.isEmpty();
    }
}

