/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.utils.ClassUtils;
import org.eclipse.e4.ui.css.swt.helpers.SWTStyleHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WidgetElement
extends ElementAdapter
implements NodeList {
    boolean dynamicEnabled = Boolean.getBoolean("org.eclipse.e4.ui.css.dynamic");
    protected String localName = this.computeLocalName();
    protected String namespaceURI = this.computeNamespaceURI();
    protected String swtStyles;

    public static String getCSSClass(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.CssClassName");
    }

    public static String getID(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.id");
    }

    public static void setCSSClass(Widget widget, String className) {
        widget.setData("org.eclipse.e4.ui.css.CssClassName", (Object)className);
    }

    public static void setID(Widget widget, String id) {
        widget.setData("org.eclipse.e4.ui.css.id", (Object)id);
    }

    public static CSSEngine getEngine(Widget widget) {
        return WidgetElement.getEngine(widget.getDisplay());
    }

    public static CSSEngine getEngine(Display display) {
        return (CSSEngine)display.getData("org.eclipse.e4.ui.css.core.engine");
    }

    public static void applyStyles(Widget widget, boolean applyStylesToChildNodes) {
        CSSEngine engine = WidgetElement.getEngine(widget);
        if (engine != null) {
            engine.applyStyles((Object)widget, applyStylesToChildNodes);
        }
    }

    public static void setEngine(Display display, CSSEngine engine) {
        display.setData("org.eclipse.e4.ui.css.core.engine", (Object)engine);
    }

    public WidgetElement(Widget widget, CSSEngine engine) {
        super((Object)widget, engine);
        this.computeStaticPseudoInstances();
        this.swtStyles = this.computeAttributeSWTStyle();
    }

    protected String computeLocalName() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getSimpleName(clazz);
    }

    protected String computeNamespaceURI() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getPackageName(clazz);
    }

    protected void computeStaticPseudoInstances() {
    }

    protected String computeAttributeSWTStyle() {
        return SWTStyleHelpers.getSWTWidgetStyleAsString(this.getWidget());
    }

    public final String getAttribute(String attr) {
        Supplier<String> attribute = this.internalGetAttribute(attr);
        if (attribute != null) {
            String attributeValue = attribute.get();
            Assert.isNotNull((Object)attributeValue);
            return attributeValue;
        }
        return "";
    }

    public final boolean hasAttribute(String attr) {
        return this.internalGetAttribute(attr) != null;
    }

    protected Supplier<String> internalGetAttribute(String attr) {
        Widget widget = this.getWidget();
        switch (attr) {
            case "style": {
                return () -> this.swtStyles != null ? this.swtStyles : "";
            }
            case "class": {
                return () -> Objects.toString(WidgetElement.getCSSClass(widget), "");
            }
            case "swt-data-class": {
                return () -> {
                    Object data = widget.getData();
                    if (data == null) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    Class<?> clazz = data.getClass();
                    while (clazz != Object.class) {
                        sb.append(clazz.getName());
                        clazz = clazz.getSuperclass();
                        sb.append(' ');
                    }
                    return sb.toString();
                };
            }
        }
        Object o = widget.getData(attr.toLowerCase());
        if (o != null) {
            return () -> o.toString();
        }
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public Node getParentNode() {
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public Node item(int index) {
        return null;
    }

    protected Widget getWidget() {
        return (Widget)this.getNativeWidget();
    }

    public String getCSSId() {
        Widget widget = this.getWidget();
        String id = WidgetElement.getID(widget);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public String getCSSClass() {
        Widget widget = this.getWidget();
        String id = WidgetElement.getCSSClass(widget);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public String getCSSStyle() {
        Widget widget = this.getWidget();
        Object id = widget.getData("style");
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public void reset() {
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.getWidget();
    }
}

