/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeModelParentCommand
extends AbstractTransactionalCommand {
    private Map<EObject, EReference> chilrendToMove;
    private EObject targetContainer;
    private IAdaptable elementAdapter;

    public ChangeModelParentCommand(TransactionalEditingDomain domain, IAdaptable parentGroupAdapter, Map<EObject, EReference> chilrendToMove, IGraphicalEditPart anyPart) {
        super(domain, "Change model parent command", null);
        this.chilrendToMove = chilrendToMove;
        this.elementAdapter = parentGroupAdapter;
        this.targetContainer = null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        Object group;
        if (this.targetContainer == null && (group = this.elementAdapter.getAdapter(EObject.class)) instanceof EObject) {
            this.targetContainer = (EObject)group;
        }
        if (this.targetContainer == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to change the model parent of the object because the system was enable to find the EObject of the parent group");
        }
        for (EObject element : this.getElementsToMove().keySet()) {
            EReference feature = this.getTargetFeature(element);
            if (feature != null && this.targetContainer.eClass().getEAllReferences().contains((Object)feature)) {
                if (feature.isMany()) {
                    Collection coll = (Collection)this.targetContainer.eGet((EStructuralFeature)feature);
                    coll.add(element);
                    continue;
                }
                this.targetContainer.eSet((EStructuralFeature)feature, (Object)element);
                continue;
            }
            return CommandResult.newErrorCommandResult((String)EMFTypeCoreMessages.moveElementsCommand_noTargetFeature);
        }
        return CommandResult.newOKCommandResult();
    }

    private Map<EObject, EReference> getElementsToMove() {
        return this.chilrendToMove;
    }

    protected EReference getTargetFeature(EObject element) {
        EReference feature = this.getElementsToMove().get(element);
        if (feature == null) {
            EReference oldContainmentFeature = element.eContainmentFeature();
            if (this.getTargetContainer().eClass().getEAllReferences().contains((Object)oldContainmentFeature)) {
                this.getElementsToMove().put(element, oldContainmentFeature);
                feature = oldContainmentFeature;
            }
        }
        if (feature == null) {
            feature = PackageUtil.findFeature((EClass)this.getTargetContainer().eClass(), (EClass)element.eClass());
            this.setTargetFeature(element, feature);
        }
        return feature;
    }

    private EObject getTargetContainer() {
        return this.targetContainer;
    }

    protected void setTargetFeature(EObject element, EReference targetFeature) {
        this.getElementsToMove().put(element, targetFeature);
    }
}

