/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.attributes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public class PackageAttribution
extends AbstractAttribution {
    public static final PackageAttribution INSTANCE = new PackageAttribution();

    @Override
    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        Package targetPackage = (Package)target;
        EnvironmentFactoryInternal environmentFactory = environmentView.getEnvironmentFactory();
        HashSet<Package> allPackages = new HashSet<Package>();
        this.gatherAllPackages(environmentFactory, allPackages, targetPackage);
        for (Package aPackage : allPackages) {
            environmentView.addAllPackages(aPackage);
            environmentView.addAllTypes(aPackage);
        }
        return scopeView.getParent();
    }

    private void gatherAllPackages(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Set<Package> allPackages, @NonNull Package targetPackage) {
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Package primaryPackage = metamodelManager.getPrimaryElement(targetPackage);
        if (allPackages.add(primaryPackage)) {
            for (Package package_ : metamodelManager.getPartialPackages(primaryPackage, false)) {
                for (Package importedPackage : package_.getImportedPackages()) {
                    this.gatherAllPackages(environmentFactory, allPackages, importedPackage);
                }
            }
        }
    }
}

