/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.widgets;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;

public class OpenViewLink
extends Composite
implements IHyperlinkListener {
    private static final String KEY_HLINK_GROUP = "hlinkGroup";
    private ImageHyperlink link;
    private Image icon = null;

    public OpenViewLink(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.link = new ImageHyperlink((Composite)this, 64);
        OpenViewLink.getHyperlinkGroup(parent).add((Hyperlink)this.link);
        this.link.addHyperlinkListener((IHyperlinkListener)this);
    }

    public void dispose() {
        super.dispose();
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        this.link = null;
    }

    static HyperlinkGroup getHyperlinkGroup(Composite parent) {
        HyperlinkGroup result = (HyperlinkGroup)parent.getData(KEY_HLINK_GROUP);
        if (result == null) {
            result = new HyperlinkGroup(parent.getDisplay());
            result.setHyperlinkUnderlineMode(3);
            parent.setData(KEY_HLINK_GROUP, (Object)result);
        }
        return result;
    }

    public String getLabel() {
        return this.link.getText();
    }

    public void setLabel(String label) {
        if (label == null) {
            label = "";
        }
        this.link.setText(label);
        this.layout(true);
    }

    public String getViewID() {
        return (String)this.link.getHref();
    }

    public void setViewID(String viewID) {
        IViewDescriptor[] views;
        this.link.setHref((Object)viewID);
        if (this.icon != null) {
            this.link.setImage(null);
            this.icon.dispose();
        }
        IViewDescriptor[] iViewDescriptorArray = views = PlatformUI.getWorkbench().getViewRegistry().getViews();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor view = iViewDescriptorArray[n2];
            if (viewID.equals(view.getId())) {
                ImageDescriptor iconDesc = view.getImageDescriptor();
                if (iconDesc == null) break;
                this.icon = iconDesc.createImage((Device)this.getDisplay());
                this.link.setImage(this.icon);
                break;
            }
            ++n2;
        }
    }

    private IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage[] pages;
        IWorkbenchPage result = null;
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null && bench.getWorkbenchWindowCount() > 0) {
            window = bench.getWorkbenchWindows()[0];
        }
        if (window != null && (result = window.getActivePage()) == null && (pages = window.getPages()).length > 0) {
            result = pages[0];
        }
        return result;
    }

    public void linkActivated(HyperlinkEvent event) {
        IWorkbenchPage page;
        String viewID;
        if (event.getSource() == this.link && (viewID = this.getViewID()) != null && (page = this.getWorkbenchPage()) != null) {
            try {
                page.showView(viewID);
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle(e.getStatus(), 2);
            }
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }
}

