/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.AbstractMultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.IMultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WrappedLabelProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractMultipleReferenceEditor
extends AbstractMultipleValueEditor<ReferenceSelector>
implements IMultipleReferenceEditor {
    protected IStaticContentProvider contentProvider;

    protected AbstractMultipleReferenceEditor(Composite parent, boolean ordered, boolean unique, String label) {
        super(parent, new ReferenceSelector(unique), ordered, unique, label);
        this.setProviders(EmptyContentProvider.instance, new WrappedLabelProvider());
    }

    protected AbstractMultipleReferenceEditor(Composite parent, String label) {
        this(parent, false, false, label);
    }

    protected AbstractMultipleReferenceEditor(Composite parent) {
        this(parent, false, false, null);
    }

    @Override
    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        Assert.isNotNull((Object)contentProvider, (String)"The content provider should be defined");
        this.contentProvider = contentProvider;
        if (this.selector instanceof ReferenceSelector) {
            ((ReferenceSelector)this.selector).setContentProvider(contentProvider);
        }
        if (labelProvider != null) {
            ((ReferenceSelector)this.selector).setLabelProvider(labelProvider);
            this.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    @Override
    public void setUnique(boolean unique) {
        ((ReferenceSelector)this.selector).setUnique(unique);
        super.setUnique(unique);
    }
}

