/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AbstractShowHideRelatedLinkEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.StereotypePropertyReferenceEdgeRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.UpdaterLinkDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.Domain2Notation;
import org.eclipse.papyrus.uml.diagram.common.helper.LinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.ShowHideRelatedLinkSelectionDialog;
import org.eclipse.papyrus.uml.diagram.common.util.LinkEndsMapper;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractUMLShowHideRelatedLinkEditPolicy
extends AbstractShowHideRelatedLinkEditPolicy {
    private static final String STEREOTYPE_PROPERTY_REFERENCE_EDGE_ELEMENT_TYPE_QN = "org.eclipse.papyrus.umldi.StereotypePropertyReferenceEdge";

    public AbstractUMLShowHideRelatedLinkEditPolicy(DiagramEditPart host) {
        super(host);
    }

    public AbstractUMLShowHideRelatedLinkEditPolicy() {
        super(null);
    }

    protected Command getShowHideRelatedLinkCommandWithDialog(Collection<EditPart> selectedEditParts, Map<EditPart, Set<EObject>> availableLinks, Set<EObject> visibleLinks, Domain2Notation domain2NotationMap, Collection<UpdaterLinkDescriptor> linksDescriptors) {
        HashMap<EObject, LinkEndsMapper> linkMapping = new HashMap<EObject, LinkEndsMapper>();
        for (UpdaterLinkDescriptor current : linksDescriptors) {
            EObject source;
            EObject link = current.getModelElement();
            if (link instanceof Element) {
                linkMapping.put(link, AbstractUMLShowHideRelatedLinkEditPolicy.createLinkEndMapper((Element)link, current));
                continue;
            }
            if (!(link instanceof EdgeWithNoSemanticElementRepresentationImpl) || !((source = ((EdgeWithNoSemanticElementRepresentationImpl)link).getSource()) instanceof Comment) && !(source instanceof Constraint) && !"StereotypePropertyReferenceEdge".equals(current.getVisualID())) continue;
            linkMapping.put(link, AbstractUMLShowHideRelatedLinkEditPolicy.createLinkEndMapper((Element)source, current));
        }
        TransactionalEditingDomain domain = this.getEditingDomain();
        CompositeCommand compositeCommand = new CompositeCommand("Show/Hide Related Link Command");
        ICommand cmd = this.getOpenDialogCommand(domain, selectedEditParts, availableLinks, visibleLinks, linkMapping);
        compositeCommand.add((IUndoableOperation)cmd);
        compositeCommand.add((IUndoableOperation)this.getComputeCommandResultCommand(domain, cmd, visibleLinks, domain2NotationMap, linksDescriptors));
        return new ICommandProxy((ICommand)compositeCommand);
    }

    protected Collection<UpdaterLinkDescriptor> removeInvalidLinkDescriptor(Collection<UpdaterLinkDescriptor> descriptor) {
        Collection firstResult = super.removeInvalidLinkDescriptor(descriptor);
        ArrayList<UpdaterLinkDescriptor> result = new ArrayList<UpdaterLinkDescriptor>();
        for (UpdaterLinkDescriptor current : firstResult) {
            EObject target;
            EObject src;
            EObject modelElement = current.getModelElement();
            if (!AbstractUMLShowHideRelatedLinkEditPolicy.isAnOrientedLink(modelElement) && (src = current.getSource()) == (target = current.getDestination())) {
                Collection<?> sources = LinkMappingHelper.getSource((Element)modelElement);
                Collection<?> targets = LinkMappingHelper.getTarget((Element)modelElement);
                if (sources.size() > 1 && sources.equals(targets)) {
                    int nbOccurencesInSource = 0;
                    Iterator<?> iterSrc = sources.iterator();
                    while (nbOccurencesInSource < 2 && iterSrc.hasNext()) {
                        if (iterSrc.next() != src) continue;
                        ++nbOccurencesInSource;
                    }
                    int nbOccurencesInTarget = 0;
                    Iterator<?> iterTarget = targets.iterator();
                    while (nbOccurencesInTarget < 2 && iterTarget.hasNext()) {
                        if (iterTarget.next() != src) continue;
                        ++nbOccurencesInTarget;
                    }
                    if (nbOccurencesInSource <= 1 && nbOccurencesInTarget <= 1) {
                        continue;
                    }
                } else if (!sources.contains(src) || !targets.contains(src)) continue;
            }
            result.add(current);
        }
        return result;
    }

    public static final boolean isAnOrientedLink(EObject link) {
        if (link instanceof DirectedRelationship) {
            return true;
        }
        if (link instanceof Relationship) {
            return false;
        }
        if (link instanceof Connector) {
            return false;
        }
        if (link instanceof Comment || link instanceof Constraint) {
            return true;
        }
        return link instanceof StereotypePropertyReferenceEdgeRepresentation;
    }

    public static final LinkEndsMapper createLinkEndMapper(Element element, UpdaterLinkDescriptor descriptor) {
        Collection<Object> targets;
        Collection<Object> sources;
        Collection<Object> ends;
        if (element instanceof Comment || element instanceof Constraint || "StereotypePropertyReferenceEdge".equals(descriptor.getVisualID())) {
            ends = Collections.emptyList();
            sources = Collections.singletonList(descriptor.getSource());
            targets = Collections.singletonList(descriptor.getDestination());
        } else if (AbstractUMLShowHideRelatedLinkEditPolicy.isAnOrientedLink((EObject)element)) {
            ends = Collections.emptyList();
            sources = LinkMappingHelper.getSource(element);
            targets = LinkMappingHelper.getTarget(element);
        } else {
            ends = LinkMappingHelper.getSource(element);
            sources = Collections.emptyList();
            targets = Collections.emptyList();
        }
        return new LinkEndsMapper((EObject)element, ends, sources, targets);
    }

    protected ICommand getOpenDialogCommand(TransactionalEditingDomain domain, final Collection<EditPart> selectedEditPart, final Map<EditPart, Set<EObject>> availableLinks, final Collection<EObject> initialSelection, final Map<EObject, LinkEndsMapper> linkMapping) {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, "Open Show/HideDialogCommand", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ShowHideRelatedLinkSelectionDialog dialog = new ShowHideRelatedLinkSelectionDialog(Display.getDefault().getActiveShell(), AbstractUMLShowHideRelatedLinkEditPolicy.this.getLabelProvider(), (ITreeContentProvider)new AbstractShowHideRelatedLinkEditPolicy.LinkContentProvider(availableLinks), availableLinks, linkMapping);
                dialog.setTitle("Show/Hide Links");
                dialog.setMessage("Choose the links to show.");
                dialog.setInput(selectedEditPart);
                dialog.setInitialSelection(initialSelection);
                dialog.setExpandedElements(selectedEditPart.toArray());
                dialog.setContainerMode(true);
                int status = dialog.open();
                if (status == 1) {
                    return CommandResult.newCancelledCommandResult();
                }
                return CommandResult.newOKCommandResult(Arrays.asList(dialog.getResult()));
            }
        };
        return cmd;
    }

    protected ILabelProvider getLabelProvider() {
        return new UMLLabelProvider();
    }

    protected Collection<? extends UpdaterLinkDescriptor> collectPartRelatedLinks(View view, Domain2Notation domain2NotationMap) {
        LinkedList<UpdaterLinkDescriptor> result = new LinkedList<UpdaterLinkDescriptor>();
        result.addAll(super.collectPartRelatedLinks(view, domain2NotationMap));
        List<UpdaterLinkDescriptor> outgoingDescriptors = this.getOutgoingStereotypePropertyReferenceLinks(view);
        result.addAll(outgoingDescriptors);
        return this.removeInvalidLinkDescriptor(result);
    }

    protected List<UpdaterLinkDescriptor> getOutgoingStereotypePropertyReferenceLinks(View view) {
        Element element = (Element)view.getElement();
        LinkedList<UpdaterLinkDescriptor> result = new LinkedList<UpdaterLinkDescriptor>();
        if (element != null) {
            IElementType type = ElementTypeRegistry.getInstance().getType(STEREOTYPE_PROPERTY_REFERENCE_EDGE_ELEMENT_TYPE_QN);
            EList appliedStereotypes = element.getAppliedStereotypes();
            for (Stereotype stereotype : appliedStereotypes) {
                Stereotype actual = stereotype == null ? null : org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)element, (Stereotype)stereotype);
                EObject stereotypeApplication = actual == null ? null : element.getStereotypeApplication(actual);
                EList eAllReferences = stereotypeApplication.eClass().getEAllReferences();
                for (EReference eReference : eAllReferences) {
                    Object referenceValue = stereotypeApplication.eGet((EStructuralFeature)eReference);
                    if (eReference.getName().startsWith("base_")) continue;
                    Stereotype stereotypeFeatureContainer = (Stereotype)stereotype.getAllAttributes().stream().filter(p -> p.getName().equals(eReference.getName())).findFirst().get().eContainer();
                    if (1 == eReference.getUpperBound()) {
                        Element target = UMLUtil.getBaseElement((EObject)((EObject)referenceValue));
                        StereotypePropertyReferenceEdgeRepresentation edgeRepresentation = new StereotypePropertyReferenceEdgeRepresentation((EObject)element, (EObject)(target == null ? (Element)referenceValue : target), stereotypeFeatureContainer.getQualifiedName(), eReference.getName(), eReference.getName());
                        result.add(new UpdaterLinkDescriptor((EObject)element, (EObject)(target == null ? (Element)referenceValue : target), (EObject)edgeRepresentation, type, "StereotypePropertyReferenceEdge"));
                        continue;
                    }
                    if (!(referenceValue instanceof List)) continue;
                    for (Object value : (List)referenceValue) {
                        Element target = UMLUtil.getBaseElement((EObject)((EObject)value));
                        StereotypePropertyReferenceEdgeRepresentation edgeRepresentation = new StereotypePropertyReferenceEdgeRepresentation((EObject)element, (EObject)(target == null ? (Element)value : target), stereotypeFeatureContainer.getQualifiedName(), eReference.getName(), eReference.getName());
                        result.add(new UpdaterLinkDescriptor((EObject)element, (EObject)(target == null ? (Element)value : target), (EObject)edgeRepresentation, type, "StereotypePropertyReferenceEdge"));
                    }
                }
            }
        }
        return result;
    }
}

