/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.xtext.base.ui.commands.ValidateCommand;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public final class ValidateHandler
implements IHandler2 {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private transient ListenerList listenerList = null;
    private boolean baseEnabled = true;
    private final ValidateCommand action = new ValidateCommand();
    private IPropertyChangeListener propertyChangeListener;

    public final void addHandlerListener(IHandlerListener handlerListener) {
        if (!this.hasListeners()) {
            this.attachListener();
        }
        this.addListenerObject(handlerListener);
    }

    protected final synchronized void addListenerObject(Object listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add(listener);
    }

    private final void attachListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getProperty();
                    ValidateHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)ValidateHandler.this, "enabled".equals(property), "handled".equals(property)));
                }
            };
        }
        this.action.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected final synchronized void clearListeners() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    private final void detachListener() {
        this.action.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public final void dispose() {
        if (this.hasListeners()) {
            this.action.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        this.action.setActiveWorkbenchPart(part);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.action.updateSelection((IStructuredSelection)selection));
        } else {
            this.setEnabled(false);
        }
        this.action.run();
        return null;
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }

    public final IAction getAction() {
        return this.action;
    }

    protected final Object[] getListeners() {
        ListenerList list = this.listenerList;
        if (list == null) {
            return EMPTY_ARRAY;
        }
        return list.getListeners();
    }

    public final boolean isEnabled() {
        return this.action.isEnabled();
    }

    public final boolean isHandled() {
        return this.action.isHandled();
    }

    protected boolean hasListeners() {
        return this.isListenerAttached();
    }

    protected final boolean isListenerAttached() {
        return this.listenerList != null;
    }

    public final void removeHandlerListener(IHandlerListener handlerListener) {
        this.removeListenerObject(handlerListener);
        if (!this.hasListeners()) {
            this.detachListener();
        }
    }

    protected final synchronized void removeListenerObject(Object listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    protected void setBaseEnabled(boolean state) {
        if (this.baseEnabled == state) {
            return;
        }
        this.baseEnabled = state;
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void setEnabled(Object evaluationContext) {
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ActionHandler(");
        buffer.append((Object)this.action);
        buffer.append(')');
        return buffer.toString();
    }
}

