/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;

public class CompositeQuickAssistProcessor
implements IQuickAssistProcessor {
    private List<IQuickAssistProcessor> fProcessors;

    public CompositeQuickAssistProcessor(List<IQuickAssistProcessor> processors) {
        this.fProcessors = processors;
    }

    public String getErrorMessage() {
        StringBuilder res = new StringBuilder();
        for (IQuickAssistProcessor processor : this.fProcessors) {
            String errorMessage = processor.getErrorMessage();
            if (errorMessage == null) continue;
            res.append(errorMessage);
            res.append('\n');
        }
        if (res.length() == 0) {
            return null;
        }
        return res.toString();
    }

    public boolean canFix(Annotation annotation) {
        for (IQuickAssistProcessor processor : this.fProcessors) {
            if (!processor.canFix(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        for (IQuickAssistProcessor processor : this.fProcessors) {
            if (!processor.canAssist(invocationContext)) continue;
            return true;
        }
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        for (IQuickAssistProcessor processor : this.fProcessors) {
            ICompletionProposal[] proposals = processor.computeQuickAssistProposals(invocationContext);
            if (proposals == null) continue;
            res.addAll(Arrays.asList(proposals));
        }
        return res.toArray(new ICompletionProposal[res.size()]);
    }
}

