/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.example.programmaticcreation;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLViewProvider;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.StructuredClassifier;

public class CreateCompositeDiagramElementsCommand
extends AbstractEMFOperation {
    public static UMLViewProvider compViewProvider = new UMLViewProvider();
    protected ExecutionEvent m_event;
    protected Class m_context;

    public CreateCompositeDiagramElementsCommand(TransactionalEditingDomain domain, ExecutionEvent event, Class context) {
        super(domain, "add collaboration use");
        this.m_context = context;
        this.m_event = event;
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject diagramEObj;
        Object windowsContainer = null;
        Object model = windowsContainer.getActiveSashWindowsPage().getRawModel();
        if (model instanceof PageRef && (diagramEObj = ((PageRef)model).getEmfPageIdentifier()) instanceof Diagram) {
            Diagram diagram = (Diagram)diagramEObj;
            View view = null;
            for (Object child : diagram.getChildren()) {
                if (!(child instanceof View) || ((View)child).getElement() != this.m_context) continue;
                view = (View)child;
            }
            CollaborationUse cu = this.m_context.createCollaborationUse("testCollaboration");
            this.addCuToCompositeDiagram(this.m_context, (StructuredClassifier)this.m_context, cu, view, diagram);
        }
        return Status.OK_STATUS;
    }

    public View addCuToCompositeDiagram(Class context, StructuredClassifier solutionClass, CollaborationUse cu, View view, Diagram diagram) {
        Object compartment = view.getChildren().get(1);
        Node roleBindingView = compViewProvider.createCollaborationUse_Shape((EObject)cu, (View)((BasicCompartment)compartment), -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        Location location = NotationFactory.eINSTANCE.createLocation();
        location.setX(50);
        location.setY(40);
        if (roleBindingView instanceof Node) {
            roleBindingView.setLayoutConstraint((LayoutConstraint)location);
        }
        return roleBindingView;
    }
}

