/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.lifecycleevents;

import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;

public class LifeCycleEventsMonitorService
implements IService {
    protected ServicesRegistry servicesRegistry;
    protected ILifeCycleEventsProvider eventProvider;
    protected ISaveEventListener aboutToSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            System.out.println("event received: aboutToSaveAs");
        }

        public void doSave(DoSaveEvent event) {
            System.out.println("event received: aboutToSave");
        }
    };
    protected ISaveEventListener saveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            System.out.println("event received: doSaveAs");
        }

        public void doSave(DoSaveEvent event) {
            System.out.println("event received: doSave");
        }
    };
    protected ISaveEventListener postSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            System.out.println("event received: postSaveAs");
        }

        public void doSave(DoSaveEvent event) {
            System.out.println("event received: postSave");
        }
    };

    public LifeCycleEventsMonitorService() {
        System.out.println("LifeCycleEventsMonitorService created");
    }

    public void disposeService() {
        this.deactivate();
        System.out.println("LifeCycleEventsMonitorService disposed");
    }

    public void init(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public void startService() {
        System.out.println("LifeCycleEventsMonitorService started");
        this.activate();
    }

    private void activate() {
        try {
            this.eventProvider = (ILifeCycleEventsProvider)this.servicesRegistry.getService(ILifeCycleEventsProvider.class);
            this.eventProvider.addAboutToDoSaveListener(this.aboutToSaveListener);
            this.eventProvider.addDoSaveListener(this.saveListener);
            this.eventProvider.addPostDoSaveListener(this.postSaveListener);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void deactivate() {
        this.eventProvider.removeAboutToDoSaveListener(this.aboutToSaveListener);
        this.eventProvider.removeDoSaveListener(this.saveListener);
        this.eventProvider.removePostDoSaveListener(this.postSaveListener);
    }
}

