/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dragtracker;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;

public class NoScrollResizeTracker
extends ResizeTracker {
    public NoScrollResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void updateSourceRequest() {
        int BORDER = 10;
        super.updateSourceRequest();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension deltaResize = request.getSizeDelta();
        Point delta = request.getMoveDelta();
        if (this.getOwner() instanceof GraphicalEditPart) {
            Rectangle childRect = this.getOwner().getFigure().getBounds();
            if (this.getOwner().getParent() instanceof GraphicalEditPart) {
                Rectangle parentRect = ((GraphicalEditPart)this.getOwner().getParent()).getFigure().getBounds();
                Rectangle virtualPosition = childRect.getCopy();
                virtualPosition.x += delta.x;
                virtualPosition.y += delta.y;
                virtualPosition.width += deltaResize.width;
                virtualPosition.height += deltaResize.height;
                if (virtualPosition.x < 0) {
                    delta.x = 0 - childRect.x;
                    deltaResize.width = Math.abs(delta.x);
                }
                if (virtualPosition.y < 0) {
                    delta.y = 0 - childRect.y;
                    deltaResize.height = Math.abs(delta.y);
                }
                if (virtualPosition.getBottomRight().x > parentRect.width - BORDER) {
                    deltaResize.width = parentRect.width - childRect.getBottomRight().x - BORDER;
                }
                if (virtualPosition.getBottomRight().y > parentRect.height - 2 * BORDER) {
                    deltaResize.height = parentRect.height - childRect.getBottomRight().y - 2 * BORDER;
                }
                request.setMoveDelta(delta);
            }
        }
    }
}

