/* Glazed Lists                                                 (c) 2003-2006 */
/* http://publicobject.com/glazedlists/                      publicobject.com,*/
/*                                                     O'Dell Engineering Ltd.*/
package com.publicobject.amazonbrowser;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.GlazedLists;

import java.util.*;

/**
 * The ItemTreeFormat specifies how a list of Items are formatted as a
 * hierarchy. Specifically, it maps a single Item to a List of Items, each of
 * which represent a node in the path to the hierarchy's root for the given
 * <code>Item</code>.
 *
 * <p>Each Item in the returned List of Items is generated by consulting each
 * of the {@link TreeCriterion} objects with which this ItemTreeFormat was
 * constructed.
 *
 * @author James Lemieux
 */
public class ItemTreeFormat implements TreeList.Format<Item> {

    /** The list of TreeCriterion objects which generate the path to the root of the treetable for each Item. */
    private final List<TreeCriterion> criteria;

    /**
     * Construct an ItemTreeFormat that determines the List of Item objects
     * for any given {@link Item} by consulting each of the given
     * <code>criteria</code> and asking them to generate the
     */
    public ItemTreeFormat(List<TreeCriterion> criteria) {
        this.criteria = criteria;
    }

    /**
     * Only virtual items have children.
     */
    public boolean allowsChildren(Item element) {
        return element.getASIN() == null;
    }

    /**
     * Populates a List of Items produced by consulting the List of
     * TreeCriterion objects this ItemTreeFormat was constructed with.
     */
    public void getPath(List<Item> path, Item item) {
        // add the generated Item from each TreeCriterion
        for (TreeCriterion criterion : criteria)
            path.add(criterion.getPathItem(item));

        path.add(item);
    }

    public Comparator<Item> getComparator(int depth) {
        return GlazedLists.comparableComparator();
    }
}