/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

class SvgTransform {
    SvgTransform next;
    float[] data = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    SvgTransform() {
    }

    float[] apply(float x, float y) {
        float[] v = new float[]{this.data[0] * x + this.data[2] * y + this.data[4], this.data[1] * x + this.data[3] * y + this.data[5]};
        return v;
    }

    boolean isIdentity() {
        return this.data.length == 6 && this.data[0] == 1.0f && this.data[1] == 0.0f && this.data[2] == 0.0f && this.data[3] == 1.0f && this.data[4] == 0.0f && this.data[5] == 0.0f;
    }

    void scale(float s) {
        this.scale(s, s);
    }

    void scale(float x, float y) {
        this.data[0] = x;
        this.data[3] = y;
    }

    void setData(Type type, String[] sa) {
        this.data = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        switch (type) {
            case Matrix: {
                int i = 0;
                while (i < sa.length) {
                    this.data[i] = Float.parseFloat(sa[i]);
                    ++i;
                }
                break;
            }
            case Translate: {
                this.data[4] = Float.parseFloat(sa[0]);
                if (sa.length <= 1) break;
                this.data[5] = Float.parseFloat(sa[1]);
                break;
            }
            case Scale: {
                if (sa.length == 1) {
                    this.scale(Float.parseFloat(sa[0]));
                    break;
                }
                if (sa.length != 2) break;
                this.scale(Float.parseFloat(sa[0]), Float.parseFloat(sa[1]));
                break;
            }
            case Rotate: {
                float angle = Float.parseFloat(sa[0]);
                this.data[0] = (float)Math.cos(Math.toRadians(angle));
                this.data[1] = (float)Math.sin(Math.toRadians(angle));
                this.data[2] = (float)(-Math.sin(Math.toRadians(angle)));
                this.data[3] = (float)Math.cos(Math.toRadians(angle));
                if (sa.length <= 1) break;
                this.data[4] = Float.parseFloat(sa[1]);
                this.data[5] = Float.parseFloat(sa[2]);
                break;
            }
            case SkewX: {
                this.data[2] = Float.parseFloat(sa[0]);
                break;
            }
            case SkewY: {
                this.data[1] = Float.parseFloat(sa[0]);
            }
        }
    }

    void skew(float x, float y) {
        this.data[2] = x;
        this.data[1] = y;
    }

    void translate(float x, float y) {
        this.data[4] = x;
        this.data[5] = y;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        Matrix,
        Translate,
        Scale,
        Rotate,
        SkewX,
        SkewY;

    }
}

