/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.widgets.Display;

public abstract class TransactionalCommandHandler<T extends ILayerCommand>
implements ILayerCommandHandler<T> {
    private final TransactionalEditingDomain domain;
    private String label;

    public TransactionalCommandHandler(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public TransactionalCommandHandler(TransactionalEditingDomain domain, String label) {
        this.domain = domain;
        this.label = label;
    }

    public String getLabel() {
        return this.label != null ? this.label : "Table Command";
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public final boolean doCommand(ILayer targetLayer, T command) {
        boolean[] result = new boolean[1];
        if (command.convertToTargetLayer(targetLayer)) {
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain, this.getLabel(), (ILayerCommand)command, result, targetLayer){
                private final /* synthetic */ ILayerCommand val$command;
                private final /* synthetic */ boolean[] val$result;
                private final /* synthetic */ ILayer val$targetLayer;
                {
                    this.val$command = iLayerCommand;
                    this.val$result = blArray;
                    this.val$targetLayer = iLayer;
                    super($anonymous0, $anonymous1);
                }

                protected void doExecute() {
                    ExecutionStatusKind status = TransactionalCommandHandler.this.doCommand(this.val$command);
                    this.val$result[0] = status.isOK();
                    if (status.isRollback()) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                val$targetLayer.doCommand((ILayerCommand)new VisualRefreshCommand());
                            }
                        });
                        throw new OperationCanceledException();
                    }
                }
            });
        }
        return result[0];
    }

    protected abstract ExecutionStatusKind doCommand(T var1);

    protected static enum ExecutionStatusKind {
        FAIL_ROLLBACK(false, true),
        OK_COMPLETE(true, false),
        OK_ROLLBACK(true, true);

        private final boolean ok;
        private final boolean rollback;

        private ExecutionStatusKind(boolean ok, boolean rollback) {
            this.ok = ok;
            this.rollback = rollback;
        }

        public boolean isOK() {
            return this.ok;
        }

        public boolean isRollback() {
            return this.rollback;
        }
    }
}

