/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.papyrus.uml.diagram.sequence.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConsiderIgnoreFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Continuation;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ElementInitializers {
    protected ElementInitializers() {
    }

    public void init_Interaction_Shape(Interaction instance) {
        try {
            String value_0 = this.name_Interaction_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_ConsiderIgnoreFragment_Shape(ConsiderIgnoreFragment instance) {
        try {
            String value_0 = this.name_ConsiderIgnoreFragment_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_CombinedFragment_Shape(CombinedFragment instance) {
        try {
            String value_0 = this.name_CombinedFragment_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_InteractionUse_Shape(InteractionUse instance) {
        try {
            String value_0 = this.name_InteractionUse_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_Continuation_Shape(Continuation instance) {
        try {
            String value_0 = this.name_Continuation_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_Lifeline_Shape(Lifeline instance) {
        try {
            String value_0 = this.name_Lifeline_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_StateInvariant_Shape(StateInvariant instance) {
        try {
            String value_0 = this.name_StateInvariant_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_DestructionOccurrenceSpecification_Shape(DestructionOccurrenceSpecification instance) {
        try {
            String value_0 = this.name_DestructionOccurrenceSpecification_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_Constraint_Shape(Constraint instance) {
        try {
            LiteralString newInstance_0_0 = UMLFactory.eINSTANCE.createLiteralString();
            instance.setSpecification((ValueSpecification)newInstance_0_0);
            String value_0_0_0 = this.value_specification_Constraint_Shape(newInstance_0_0);
            if (value_0_0_0 != null) {
                newInstance_0_0.setValue(value_0_0_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_Comment_Shape(Comment instance) {
        try {
            Object value_0 = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getComment(), null).evaluate(instance);
            if (value_0 != null) {
                instance.setBody((String)value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_TimeConstraint_Shape(TimeConstraint instance) {
        try {
            String value_0 = this.name_TimeConstraint_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_TimeObservation_Shape(TimeObservation instance) {
        try {
            String value_0 = this.name_TimeObservation_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    private void init_TimeInterval(TimeInterval instance) {
        TimeInterval timeInterval = instance;
        Package package_ = timeInterval.getNearestPackage();
        TimeExpression minTimeExpression = UMLFactory.eINSTANCE.createTimeExpression();
        TimeExpression maxTimeExpression = UMLFactory.eINSTANCE.createTimeExpression();
        package_.getPackagedElements().add((Object)minTimeExpression);
        package_.getPackagedElements().add((Object)maxTimeExpression);
        ElementInitializers.init_NamedElement((NamedElement)minTimeExpression, "", timeInterval.eClass().getName(), "Min");
        ElementInitializers.init_NamedElement((NamedElement)maxTimeExpression, "", timeInterval.eClass().getName(), "Max");
        timeInterval.setMin((ValueSpecification)minTimeExpression);
        timeInterval.setMax((ValueSpecification)maxTimeExpression);
        minTimeExpression.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
        maxTimeExpression.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
    }

    private void init_DurationInterval(DurationInterval instance) {
        DurationInterval durationInterval = instance;
        Package package_ = durationInterval.getNearestPackage();
        Duration minDuration = UMLFactory.eINSTANCE.createDuration();
        Duration maxDuration = UMLFactory.eINSTANCE.createDuration();
        package_.getPackagedElements().add((Object)minDuration);
        package_.getPackagedElements().add((Object)maxDuration);
        ElementInitializers.init_NamedElement((NamedElement)minDuration, "", durationInterval.eClass().getName(), "Min");
        ElementInitializers.init_NamedElement((NamedElement)maxDuration, "", durationInterval.eClass().getName(), "Max");
        durationInterval.setMin((ValueSpecification)minDuration);
        durationInterval.setMax((ValueSpecification)maxDuration);
        minDuration.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
        maxDuration.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
    }

    public void init_GeneralOrdering_Edge(GeneralOrdering instance) {
        try {
            String value_0 = this.name_GeneralOrdering_Edge(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_DurationConstraint_Edge(DurationConstraint instance) {
        try {
            String value_0 = this.name_DurationConstraint_Edge(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    public void init_DurationObservation_Edge(DurationObservation instance) {
        try {
            String value_0 = this.name_DurationObservation_Edge(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    private String name_Interaction_Shape(Interaction it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_ConsiderIgnoreFragment_Shape(ConsiderIgnoreFragment it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_CombinedFragment_Shape(CombinedFragment it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_InteractionUse_Shape(InteractionUse it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_Continuation_Shape(Continuation it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_Lifeline_Shape(Lifeline it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_StateInvariant_Shape(StateInvariant it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_DestructionOccurrenceSpecification_Shape(DestructionOccurrenceSpecification it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String value_specification_Constraint_Shape(LiteralString it) {
        return "";
    }

    private String name_TimeConstraint_Shape(TimeConstraint it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_TimeObservation_Shape(TimeObservation it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_GeneralOrdering_Edge(GeneralOrdering it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_DurationConstraint_Edge(DurationConstraint it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    private String name_DurationObservation_Edge(DurationObservation it) {
        return ElementInitializers.getNamedElement((NamedElement)it, "", it.eClass().getName(), "");
    }

    public static ElementInitializers getInstance() {
        ElementInitializers cached = UMLDiagramEditorPlugin.getInstance().getElementInitializers();
        if (cached == null) {
            cached = new ElementInitializers();
            UMLDiagramEditorPlugin.getInstance().setElementInitializers(cached);
        }
        return cached;
    }

    public static void init_NamedElement(NamedElement namedElement) {
        ElementInitializers.init_NamedElement(namedElement, "");
    }

    public static void init_NamedElement(NamedElement namedElement, String prefix) {
        ElementInitializers.init_NamedElement(namedElement, prefix, namedElement.eClass().getName(), "");
    }

    public static void init_NamedElement(NamedElement namedElement, String prefix, String suffix) {
        ElementInitializers.init_NamedElement(namedElement, prefix, namedElement.eClass().getName(), suffix);
    }

    public static void init_NamedElement(NamedElement namedElement, String prefix, String body, String suffix) {
        try {
            namedElement.setName(ElementInitializers.getNamedElement(namedElement, prefix, body, suffix));
        }
        catch (RuntimeException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e);
        }
    }

    private static String getNamedElement(NamedElement namedElement, String prefix, String body, String suffix) {
        String base = String.valueOf(prefix) + body + suffix;
        Namespace namespace = namedElement.getNamespace();
        if (namespace != null) {
            HashSet members = new HashSet();
            members.addAll(namespace.getMembers());
            if (namespace instanceof Interaction) {
                members.addAll(((Interaction)namespace).getGeneralOrderings());
            }
            return ElementInitializers.getNextNumberedName(members, base);
        }
        return base;
    }

    public static String getNextNumberedName(Collection currentElements, String base) {
        int nextNumber = -1;
        HashSet<String> elementNames = new HashSet<String>();
        for (Object o : currentElements) {
            String name;
            if (!(o instanceof NamedElement) || (name = ((NamedElement)o).getName()) == null || !name.startsWith(base)) continue;
            elementNames.add(name);
            String end = name.substring(base.length());
            int nextNumberTmp = -1;
            if (end.trim().equals("")) {
                nextNumberTmp = 0;
            } else {
                try {
                    nextNumberTmp = Integer.parseInt(end) + 1;
                }
                catch (NumberFormatException ex) {
                    nextNumberTmp = -1;
                }
            }
            if (nextNumberTmp <= nextNumber) continue;
            nextNumber = nextNumberTmp;
        }
        if (nextNumber == -1) {
            return ElementInitializers.generateUniqueName(base, elementNames, base, nextNumber);
        }
        return ElementInitializers.generateUniqueName(String.valueOf(base) + nextNumber, elementNames, base, nextNumber);
    }

    private static String generateUniqueName(String name, Set<String> elementNames, String base, int nextNumber) {
        while (elementNames.contains(name)) {
            name = String.valueOf(base) + ++nextNumber;
        }
        return name;
    }
}

