/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custompt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Shadow implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    IN(1, "IN", "IN"),
    OUT(2, "OUT", "OUT");

    public static final int NONE_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    private static final Shadow[] VALUES_ARRAY;
    public static final List<Shadow> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Shadow[]{NONE, IN, OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Shadow get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shadow result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shadow getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shadow result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shadow get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
        }
        return null;
    }

    private Shadow(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

