/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.advice;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.NotationAndTypeAdapter;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeCommand;
import org.eclipse.uml2.uml.InteractionOperand;

public class InteractionOperandViewAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ICommand beforeDestroyDependentsCommand = super.getBeforeDestroyDependentsCommand(request);
        if (request.getElementToDestroy() instanceof InteractionOperand) {
            Set<View> operandViews = this.findOperandViews((InteractionOperand)request.getElementToDestroy());
            return CompositeCommand.compose((ICommand)beforeDestroyDependentsCommand, (ICommand)operandViews.stream().map(view -> this.getSizeCommandFor((View)view, request.getEditingDomain())).reduce(null, CompositeCommand::compose));
        }
        return beforeDestroyDependentsCommand;
    }

    private Set<View> findOperandViews(InteractionOperand operand) {
        return EMFHelper.getUsages((EObject)operand).stream().filter(setting -> setting.getEStructuralFeature() == NotationPackage.Literals.VIEW__ELEMENT).map(EStructuralFeature.Setting::getEObject).filter(View.class::isInstance).map(View.class::cast).filter(view -> view.getElement() == operand).filter(view -> "InteractionOperand_Shape".equals(view.getType())).collect(Collectors.toSet());
    }

    private ICommand getSizeCommandFor(final View viewToDestroy, final TransactionalEditingDomain editingDomain) {
        return new AbstractTransactionalCommand(editingDomain, "Resize sibling operand", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Dimension deletedSize = InteractionOperandViewAdvice.this.getSize(viewToDestroy);
                if (deletedSize == null) {
                    return null;
                }
                View viewBefore = InteractionOperandViewAdvice.findViewBefore(viewToDestroy);
                int height = deletedSize.height();
                if (viewBefore != null) {
                    Dimension sizeOfViewBefore = InteractionOperandViewAdvice.this.getSize(viewBefore);
                    sizeOfViewBefore.expand(0, height);
                    NotationAndTypeAdapter adapter = new NotationAndTypeAdapter(viewBefore.getElement(), viewBefore);
                    SetResizeCommand result = new SetResizeCommand(editingDomain, "Expand previous operand", (IAdaptable)adapter, sizeOfViewBefore);
                    result.execute(monitor, info);
                } else {
                    View viewAfter = InteractionOperandViewAdvice.findViewAfter(viewToDestroy);
                    if (viewAfter != null) {
                        Rectangle boundsOfViewAfter = InteractionOperandViewAdvice.this.getBounds(viewAfter);
                        boundsOfViewAfter.height += height;
                        boundsOfViewAfter.y -= height;
                        NotationAndTypeAdapter adapter = new NotationAndTypeAdapter(viewAfter.getElement(), viewAfter);
                        SetResizeAndLocationCommand result = new SetResizeAndLocationCommand(editingDomain, "Expand previous operand", (IAdaptable)adapter, boundsOfViewAfter);
                        result.execute(monitor, info);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static View findViewAfter(View view) {
        if (!(view.eContainer() instanceof View)) {
            return null;
        }
        EList viewSiblings = ((View)view.eContainer()).getPersistedChildren();
        int index = viewSiblings.indexOf(view);
        int indexAfter = index + 1;
        if (indexAfter < viewSiblings.size()) {
            return (View)viewSiblings.get(indexAfter);
        }
        return null;
    }

    private static View findViewBefore(View view) {
        if (!(view.eContainer() instanceof View)) {
            return null;
        }
        EList viewSiblings = ((View)view.eContainer()).getPersistedChildren();
        int index = viewSiblings.indexOf(view) - 1;
        if (index >= 0) {
            return (View)viewSiblings.get(index);
        }
        return null;
    }

    private Rectangle getBounds(View view) {
        if (view instanceof Node) {
            Node node = (Node)view;
            LayoutConstraint constraint = node.getLayoutConstraint();
            Rectangle bounds = new Rectangle();
            if (constraint instanceof Size) {
                Size size = (Size)constraint;
                bounds.setSize(size.getWidth(), size.getHeight());
            }
            if (constraint instanceof Location) {
                Location location = (Location)constraint;
                bounds.setLocation(location.getX(), location.getY());
            }
            return bounds;
        }
        return null;
    }

    private Dimension getSize(View viewToDestroy) {
        Rectangle bounds = this.getBounds(viewToDestroy);
        return bounds == null ? null : bounds.getSize();
    }
}

