/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.toolsmiths.Activator;
import org.eclipse.papyrus.toolsmiths.factory.ExtensionFactory;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.FileBasedCustomizableElement;
import org.w3c.dom.Element;

public abstract class FileBasedExtensionFactory
implements ExtensionFactory {
    protected final String extensionPoint;
    protected final String fileAttributeName;
    protected final String fileElementName;
    protected final boolean allowMultiple;
    protected final String name;

    public FileBasedExtensionFactory(String name, String extensionPoint, String fileAttributeName, String fileElementName, boolean allowMultiple) {
        this.extensionPoint = extensionPoint;
        this.fileAttributeName = fileAttributeName;
        this.fileElementName = fileElementName;
        this.allowMultiple = allowMultiple;
        this.name = name;
    }

    public void addElement(CustomizableElement element, IPluginEditor editor) {
        this.createExtension((FileBasedCustomizableElement)element, editor);
        try {
            this.copyFile((FileBasedCustomizableElement)element, editor);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected Element createExtension(FileBasedCustomizableElement element, IPluginEditor editor) {
        Element extensionElement = null;
        if (element instanceof FileBasedCustomizableElement) {
            Element extension = editor.addExtension(this.extensionPoint);
            extensionElement = editor.addChild(extension, this.fileElementName);
            editor.setAttribute(extensionElement, this.fileAttributeName, this.getTargetPath(element));
        }
        return extensionElement;
    }

    protected void copyFile(FileBasedCustomizableElement element, IPluginEditor editor) throws FileNotFoundException, IOException {
        this.copyFile(element.getFile(), this.getTargetPath(element), editor);
    }

    protected void copyFile(String sourcePath, String targetPath, IPluginEditor editor) throws FileNotFoundException, IOException {
        File sourceFile = FileUtil.getFile((String)sourcePath);
        File targetFile = FileUtil.getWorkspaceFile((String)("/" + editor.getProject().getName() + "/" + targetPath));
        if (sourceFile == null) {
            throw new IllegalArgumentException("The source path " + sourcePath + " is not valid");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("The target path " + targetPath + " is not valid");
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        this.copy(new FileInputStream(sourceFile), targetFile);
        editor.addToBuild(targetPath);
    }

    protected String getTargetPath(FileBasedCustomizableElement element) {
        return "/" + this.getFileName(element);
    }

    protected String getFileName(FileBasedCustomizableElement element) {
        return this.getFileName(element.getFile());
    }

    protected String getFileName(String path) {
        if (path == null) {
            throw new IllegalArgumentException("File path should not be null");
        }
        String fileName = (path = path.replace("\\", "/")).indexOf("/") < 0 ? path : path.substring(path.lastIndexOf("/") + 1, path.length());
        return fileName;
    }

    protected void copy(InputStream source, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(target);
        try {
            int c;
            while ((c = source.read()) != -1) {
                ((OutputStream)out).write(c);
            }
        }
        finally {
            source.close();
            ((OutputStream)out).close();
        }
    }

    public boolean isValidElement(CustomizableElement element) {
        return element instanceof FileBasedCustomizableElement;
    }

    public String getName() {
        return this.name;
    }
}

