/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.providers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.types.core.notification.TypesEventsChain;
import org.eclipse.papyrus.infra.types.core.notification.events.ITypesEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.TypesEventKind;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TypesEventLabelProvider
extends LabelProvider
implements IColorProvider {
    Color yellow = new Color((Device)Display.getCurrent(), new RGB(255, 200, 0));
    Color green = new Color((Device)Display.getCurrent(), new RGB(0, 128, 0));
    Color red = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
    Color black = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
    Color blue = new Color((Device)Display.getCurrent(), new RGB(0, 0, 255));

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd - hh:mm:ss:SSS");
        if (element instanceof ITypesEvent) {
            calendar.setTimeInMillis(((ITypesEvent)element).getTimestamp());
            result = String.valueOf(result) + "[" + formater.format(calendar.getTime()) + "] " + ((ITypesEvent)element).getEventName();
        } else if (element instanceof TypesEventsChain) {
            calendar.setTimeInMillis(((TypesEventsChain)element).getTimestamp());
            result = String.valueOf(result) + "[" + formater.format(calendar.getTime()) + "] " + ((TypesEventsChain)element).getName();
        } else {
            result = element instanceof Map.Entry ? String.valueOf(result) + ((Map.Entry)element).getKey().toString() : String.valueOf(result) + element.toString();
        }
        return result;
    }

    public Color getForeground(Object element) {
        if (element instanceof ITypesEvent) {
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.Disapproved)) {
                return this.red;
            }
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.Unexecutable)) {
                return this.red;
            }
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.Executable)) {
                return this.green;
            }
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.Approved)) {
                return this.green;
            }
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.Identity)) {
                return this.yellow;
            }
            if (((ITypesEvent)element).getEventType().equals((Object)TypesEventKind.RequestConfiguration)) {
                return this.blue;
            }
        } else if (element instanceof Map.Entry) {
            Object value = ((Map.Entry)element).getValue();
            if (value instanceof Collection) {
                return this.checkWorst((Collection)value, true);
            }
        } else if (element instanceof TypesEventsChain) {
            return this.checkWorst(((TypesEventsChain)element).getAllEvents(), false);
        }
        return this.black;
    }

    private Color checkWorst(Collection<?> value, boolean considerRequestConfiguration) {
        Color result = this.green;
        for (Object object : value) {
            if (((ITypesEvent)object).getEventType().equals((Object)TypesEventKind.Disapproved)) {
                return this.red;
            }
            if (((ITypesEvent)object).getEventType().equals((Object)TypesEventKind.Unexecutable)) {
                return this.red;
            }
            if (((ITypesEvent)object).getEventType().equals((Object)TypesEventKind.Identity)) {
                if (result != this.green) continue;
                result = this.yellow;
                continue;
            }
            if (!((ITypesEvent)object).getEventType().equals((Object)TypesEventKind.RequestConfiguration) || !considerRequestConfiguration || result == this.yellow || result == this.red) continue;
            result = this.blue;
        }
        return result;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

