/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectCreationEntry;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfigurationFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileToolsStereotypeMetaclassTreeContentProvider
implements ITreeContentProvider {
    protected final Collection<PaletteEntry> standardEntries;

    public ProfileToolsStereotypeMetaclassTreeContentProvider(Profile profile, Collection<PaletteEntry> standardEntries) {
        this.standardEntries = standardEntries;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        if (parentElement instanceof Profile) {
            children = ((Profile)parentElement).getOwnedStereotypes().toArray();
        } else if (parentElement instanceof Stereotype) {
            ArrayList<AspectCreationEntry> entries = new ArrayList<AspectCreationEntry>();
            Stereotype stereotype = (Stereotype)parentElement;
            for (PaletteEntry entry : this.standardEntries) {
                EClass toolMetaclass;
                if (!(entry instanceof CombinedTemplateCreationEntry) || (toolMetaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entry))) == null) continue;
                EList metaclasses = stereotype.getAllExtendedMetaclasses();
                for (Class stMetaclass : metaclasses) {
                    EClassifier metaClassifier;
                    java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                    if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(toolMetaclass)) continue;
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("StereotypesToApply", stereotype.getQualifiedName());
                    ApplyStereotypeAdviceConfiguration applyStereotypeAdvice = ApplyStereotypeAdviceConfigurationFactory.createApplyStereotypeAdvice(Collections.singletonList(stereotype.getQualifiedName()), (String)"", null);
                    properties.put("advicesToApply", Collections.singletonList(applyStereotypeAdvice));
                    StringBuilder name = new StringBuilder();
                    name.append(stereotype.getName());
                    name.append(" (");
                    name.append(entry.getLabel());
                    name.append(")");
                    AspectCreationEntry aspectEntry = new AspectCreationEntry(name.toString(), "", entry.getId(), entry.getSmallIcon(), (CombinedTemplateCreationEntry)entry, properties);
                    entries.add(aspectEntry);
                }
            }
            children = entries.toArray();
        } else {
            children = new Object[]{};
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (inputElement instanceof Profile) {
            Object[] stereotypes;
            Object[] objectArray = stereotypes = ((Profile)inputElement).getOwnedStereotypes().toArray();
            int n = stereotypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object stereotype = objectArray[n2];
                if (this.hasChildren(stereotype)) {
                    elements.add(stereotype);
                }
                ++n2;
            }
        }
        return elements != null ? elements.toArray() : new Object[]{};
    }

    public Object getParent(Object element) {
        return element instanceof Stereotype ? ((Stereotype)element).getProfile() : null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

