/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InheritanceKind implements Enumerator
{
    NONE(0, "none", "none"),
    ALL(1, "all", "all");

    public static final int NONE_VALUE = 0;
    public static final int ALL_VALUE = 1;
    private static final InheritanceKind[] VALUES_ARRAY;
    public static final List<InheritanceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InheritanceKind[]{NONE, ALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InheritanceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InheritanceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InheritanceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InheritanceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InheritanceKind get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ALL;
            }
        }
        return null;
    }

    private InheritanceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

