/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class PapyrusExampleInstallerWizard
extends ExampleInstallerWizard {
    protected void loadFromExtensionPoints() {
        this.projectDescriptors = new ArrayList();
        this.filesToOpen = new ArrayList();
        String wizardID = this.wizardConfigurationElement.getAttribute("id");
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CommonUIPlugin.INSTANCE.getSymbolicName(), "examples");
        IConfigurationElement[] exampleElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < exampleElements.length) {
            IConfigurationElement exampleElement = exampleElements[i];
            if ("example".equals(exampleElement.getName()) && wizardID.equals(exampleElement.getAttribute("wizardID"))) {
                IConfigurationElement[] projectDescriptorElements = exampleElement.getChildren("projectDescriptor");
                int j = 0;
                while (j < projectDescriptorElements.length) {
                    String contentURI;
                    IConfigurationElement projectDescriptorElement = projectDescriptorElements[j];
                    String projectName = projectDescriptorElement.getAttribute("name");
                    if (projectName != null && (contentURI = projectDescriptorElement.getAttribute("contentURI")) != null) {
                        AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor = new AbstractExampleInstallerWizard.ProjectDescriptor();
                        projectDescriptor.setName(projectName);
                        URI uri = URI.createURI((String)contentURI);
                        if (uri.isRelative()) {
                            uri = URI.createPlatformPluginURI((String)(String.valueOf(projectDescriptorElement.getContributor().getName()) + "/" + contentURI), (boolean)true);
                        }
                        projectDescriptor.setContentURI(uri);
                        projectDescriptor.setDescription(projectDescriptorElement.getAttribute("description"));
                        this.projectDescriptors.add(projectDescriptor);
                    }
                    ++j;
                }
                if (!this.projectDescriptors.isEmpty()) {
                    IConfigurationElement[] openElements = exampleElement.getChildren("fileToOpen");
                    int j2 = 0;
                    while (j2 < openElements.length) {
                        IConfigurationElement openElement = openElements[j2];
                        String location = openElement.getAttribute("location");
                        if (location != null) {
                            AbstractExampleInstallerWizard.FileToOpen fileToOpen = new AbstractExampleInstallerWizard.FileToOpen();
                            fileToOpen.setLocation(location);
                            fileToOpen.setEditorID(openElement.getAttribute("editorID"));
                            this.filesToOpen.add(fileToOpen);
                        }
                        ++j2;
                    }
                    String imagePath = exampleElement.getAttribute("pageImage");
                    if (imagePath != null) {
                        if (!(imagePath = imagePath.replace('\\', '/')).startsWith("/")) {
                            imagePath = "/" + imagePath;
                        }
                        Bundle pluginBundle = Platform.getBundle((String)exampleElement.getDeclaringExtension().getContributor().getName());
                        try {
                            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(imagePath));
                            this.setDefaultPageImageDescriptor(imageDescriptor);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void openEditor(IFile file, String editorID) throws PartInitException {
        IEditorRegistry editorRegistry = this.getWorkbench().getEditorRegistry();
        if (editorID == null || editorRegistry.findEditor(editorID) == null) {
            editorID = this.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId();
        }
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), editorID, true);
    }

    public boolean performFinish() {
        Control list;
        Control control = this.projectPage.getControl();
        if (control instanceof Composite && (list = ((Composite)control).getChildren()[0]) instanceof List) {
            int index = ((List)list).getSelectionIndex();
            AbstractExampleInstallerWizard.FileToOpen fileToOpen = (AbstractExampleInstallerWizard.FileToOpen)this.filesToOpen.get(index);
            AbstractExampleInstallerWizard.ProjectDescriptor projectToCreate = (AbstractExampleInstallerWizard.ProjectDescriptor)this.projectDescriptors.get(index);
            this.projectDescriptors.clear();
            this.filesToOpen.clear();
            this.projectDescriptors.add(projectToCreate);
            this.filesToOpen.add(fileToOpen);
        }
        return super.performFinish();
    }
}

