/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.ui.editors;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericToolbarConfiguration;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.namereferences.NameReferencesHelper;
import org.eclipse.papyrus.uml.tools.providers.SemanticUMLContentProvider;
import org.eclipse.papyrus.uml.tools.util.UMLProviderHelper;
import org.eclipse.papyrus.uml.ui.editors.UMLToolbarConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRichtextEditorWithReferences
extends GenericRichTextEditor {
    private TextReferencesHelper textReferencesHelper;
    private IStaticContentProvider referenceContentProvider;
    private ILabelProvider labelProvider;

    public UMLRichtextEditorWithReferences(Composite parent, int style) {
        this(parent, new UMLToolbarConfiguration(), style);
    }

    public UMLRichtextEditorWithReferences(Composite parent, UMLToolbarConfiguration toolbarConfig, int style) {
        super(parent, (GenericToolbarConfiguration)toolbarConfig, style);
    }

    public UMLRichtextEditorWithReferences(Composite parent, UMLToolbarConfiguration toolbarConfig) {
        this(parent, toolbarConfig, 0);
    }

    public UMLRichtextEditorWithReferences(Composite parent) {
        this(parent, 0);
    }

    public void configureEdition(EObject editedElement, EStructuralFeature editedFeature) {
        super.configureEdition(editedElement, editedFeature);
        if (editedElement != null) {
            this.setContentProvider(this.createContentProvider(editedElement, editedFeature));
            this.setTextReferencesHelper(this.createTextReferencesHelper(editedElement));
            this.setLabelProvider(this.createLabelProvider(editedElement));
        }
    }

    public void setText(String value) {
        this.enableTags();
        String text = null;
        if (this.isTagsEnabled() && this.textReferencesHelper != null) {
            try {
                String result;
                Pattern regex = Pattern.compile("(\\{\\@link)(\\s*?)(.*?)(\\s*?)(\\})", 2);
                Matcher matcher = regex.matcher(value);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String reference = matcher.group(3).replaceAll("\\s", "");
                    String name = this.textReferencesHelper.replaceReferences("{@link " + reference + "}");
                    String realName = name.replaceAll("\\<u\\>", "").replaceAll("\\<\\/u\\>", "");
                    matcher.appendReplacement(buffer, "<a class=\"internal_ref\" href=\"" + reference + "\">" + realName + "</a>");
                }
                matcher.appendTail(buffer);
                text = result = buffer.toString();
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                text = value;
            }
        } else {
            text = value;
        }
        super.setText(text);
    }

    public String getText() {
        String returnedText = super.getText();
        if (this.isTagsEnabled()) {
            try {
                String source = returnedText;
                if (source != null && source.length() > 0) {
                    Pattern regex = Pattern.compile("(\\<a)((\\s*)|(.*?)(\\s+))(class=\\\")((\\s*)|(.*?)(\\s+))(internal_ref)((\\s*)|(\\s+)(.*?))(\\\")((\\s*)|(.*?)(\\s+))(href=\\\")(.*?)(\\\")(.*?)(\\>)(.*?)(\\<\\/a\\>)", 34);
                    Matcher matcher = regex.matcher(source);
                    StringBuffer buffer = new StringBuffer();
                    while (matcher.find()) {
                        matcher.appendReplacement(buffer, "{@link " + matcher.group(22) + "}");
                    }
                    matcher.appendTail(buffer);
                    String result = buffer.toString();
                    if (result != null && result.length() > 0) {
                        regex = Pattern.compile("(\\<a)((\\s*)|(.*?)(\\s+))(href=\\\")(.*?)(\\\")((\\s*)|(.*?)(\\s+))(class=\\\")((\\s*)|(.*?)(\\s+))(internal_ref)((\\s*)|(\\s+)(.*?))(\\\")(.*?)(\\>)(.*?)(\\<\\/a\\>)", 34);
                        matcher = regex.matcher(result);
                        buffer = new StringBuffer();
                        while (matcher.find()) {
                            matcher.appendReplacement(buffer, "{@link " + matcher.group(7) + "}");
                        }
                        matcher.appendTail(buffer);
                        result = buffer.toString();
                    }
                    returnedText = result;
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return returnedText;
    }

    private IStaticContentProvider createContentProvider(EObject editedElement, EStructuralFeature editedFeature) {
        EMFGraphicalContentProvider provider = null;
        if (editedElement != null && editedFeature != null) {
            Resource baseResource = editedElement.eResource();
            ResourceSet resourceSet = null;
            if (baseResource != null) {
                resourceSet = baseResource.getResourceSet();
            }
            if (resourceSet != null) {
                SemanticUMLContentProvider semanticProvider = new SemanticUMLContentProvider(editedElement, editedFeature, resourceSet);
                semanticProvider.setWantedMetaclasses(Collections.singletonList(UMLPackage.eINSTANCE.getNamedElement()));
                provider = UMLProviderHelper.encapsulateProvider((IStructuredContentProvider)semanticProvider, (EObject)editedElement, (EStructuralFeature)editedFeature, (ResourceSet)resourceSet);
            }
        }
        return provider;
    }

    private TextReferencesHelper createTextReferencesHelper(EObject editedElement) {
        NameReferencesHelper helper = null;
        if (editedElement != null && editedElement.eResource() != null) {
            helper = new NameReferencesHelper(editedElement.eResource());
        }
        return helper;
    }

    private ILabelProvider createLabelProvider(EObject editedElement) {
        ILabelProvider labelProvider = null;
        if (editedElement != null) {
            LabelProviderService lpSvc = null;
            try {
                lpSvc = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)editedElement);
                labelProvider = lpSvc.getLabelProvider();
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return labelProvider;
    }

    public void setTextReferencesHelper(TextReferencesHelper textReferencesHelper) {
        this.textReferencesHelper = textReferencesHelper;
    }

    public TextReferencesHelper getTextReferencesHelper() {
        return this.textReferencesHelper;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setContentProvider(IStaticContentProvider referenceContentProvider) {
        this.referenceContentProvider = referenceContentProvider;
    }

    public IStaticContentProvider getContentProvider() {
        return this.referenceContentProvider;
    }
}

