/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.uml2.uml.Profile;

public class ProfileExtensionsChecker
implements IPluginChecker {
    private final IProject project;
    private final IFile profileFile;
    private final Collection<Profile> existingProfiles;

    public ProfileExtensionsChecker(IProject project, IFile profileFile, Collection<Profile> existingProfiles) {
        this.project = project;
        this.profileFile = profileFile;
        this.existingProfiles = existingProfiles;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate 'plugin.xml' file for profile '" + this.profileFile.getName() + "'.");
        }
        HashSet<Profile> profiles = new HashSet<Profile>(this.existingProfiles);
        boolean foundExtensionUMLProfile = false;
        for (IPluginExtension extension : ProjectManagementService.getPluginExtensions((IProject)this.project)) {
            String locationValue;
            IPluginAttribute pluginAtttribute;
            int n;
            int n2;
            IPluginAttribute[] iPluginAttributeArray;
            IPluginObject pluginObject;
            int n3;
            int n4;
            IPluginObject[] iPluginObjectArray;
            if (!foundExtensionUMLProfile && "org.eclipse.papyrus.uml.extensionpoints.UMLProfile".equals(extension.getPoint())) {
                iPluginObjectArray = extension.getChildren();
                n4 = iPluginObjectArray.length;
                n3 = 0;
                while (n3 < n4) {
                    pluginObject = iPluginObjectArray[n3];
                    if (pluginObject instanceof IPluginElement && "profile".equals(pluginObject.getName())) {
                        iPluginAttributeArray = ((IPluginElement)pluginObject).getAttributes();
                        n2 = iPluginAttributeArray.length;
                        n = 0;
                        while (n < n2) {
                            pluginAtttribute = iPluginAttributeArray[n];
                            if ("path".equals(pluginAtttribute.getName()) && (locationValue = pluginAtttribute.getValue()).endsWith(this.profileFile.getName())) {
                                foundExtensionUMLProfile = true;
                            }
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            if (profiles.isEmpty() || !"org.eclipse.uml2.uml.generated_package".equals(extension.getPoint())) continue;
            iPluginObjectArray = extension.getChildren();
            n4 = iPluginObjectArray.length;
            n3 = 0;
            while (n3 < n4) {
                pluginObject = iPluginObjectArray[n3];
                if (pluginObject instanceof IPluginElement && "profile".equals(pluginObject.getName())) {
                    iPluginAttributeArray = ((IPluginElement)pluginObject).getAttributes();
                    n2 = iPluginAttributeArray.length;
                    n = 0;
                    while (n < n2) {
                        pluginAtttribute = iPluginAttributeArray[n];
                        if ("location".equals(pluginAtttribute.getName())) {
                            locationValue = pluginAtttribute.getValue();
                            Iterator profilesIt = profiles.iterator();
                            while (profilesIt.hasNext()) {
                                Profile currentProfile = (Profile)profilesIt.next();
                                String profileId = ((XMIResource)currentProfile.eResource()).getID((EObject)currentProfile);
                                if (!locationValue.endsWith(String.valueOf(this.profileFile.getName()) + "#" + profileId)) continue;
                                profilesIt.remove();
                                break;
                            }
                        }
                        ++n;
                    }
                }
                ++n3;
            }
        }
        if (!foundExtensionUMLProfile || !profiles.isEmpty()) {
            IFile pluginXMLFile = ProjectManagementService.getPluginXMLFile((IContainer)this.project);
            if (!foundExtensionUMLProfile) {
                MarkersService.createMarker((IResource)pluginXMLFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("The extension point 'org.eclipse.papyrus.uml.extensionpoints.UMLProfile' should be created for profile '" + this.profileFile.getName() + "'"), (int)1);
            }
            if (!profiles.isEmpty()) {
                for (Profile profile : profiles) {
                    MarkersService.createMarker((IResource)pluginXMLFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("There is no extension point 'org.eclipse.uml2.uml.generated_package' for profile '" + profile.getName() + "'."), (int)2);
                }
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

