/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.ExpressionHelper;

public class FileStatement
extends Statement {
    private final ExpressionHelper fileName;
    private final Statement[] body;
    private final Identifier mode;

    public FileStatement(int start, int end, int line, OCLExpressionCS fileNameCS, Statement[] body, Identifier mode) {
        super(start, end, line);
        this.fileName = new ExpressionHelper(fileNameCS, this);
        this.body = body;
        this.mode = mode;
    }

    public ExpressionHelper getTargetFileName() {
        return this.fileName;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public Identifier getMode() {
        return this.mode;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier result = this.fileName.analyze(ctx, issues);
        if (ctx.getOCLEnvironment().getOCLStandardLibrary().getString() != result) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "String expected!", this.fileName));
        }
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement element = statementArray[n2];
            element.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        Object result = this.fileName.evaluate(ctx);
        if (result == null) {
            throw new EvaluationException("Nullevaluation", this.fileName);
        }
        String fileName = result.toString();
        String modeVal = null;
        if (this.mode != null) {
            modeVal = this.mode.getValue();
        }
        ctx.getScope().getOutput().openFile(fileName, modeVal);
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement element = statementArray[n2];
            element.evaluate(ctx);
            ++n2;
        }
        ctx.getScope().getOutput().closeFile();
    }
}

