/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.map.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.gmf.internal.common.migrate.MigrationDelegateImpl;
import org.eclipse.papyrus.gmf.mappings.FeatureLabelMapping;
import org.eclipse.papyrus.gmf.mappings.FeatureValueSpec;
import org.eclipse.papyrus.gmf.mappings.GMFMapFactory;
import org.eclipse.papyrus.gmf.mappings.GMFMapPackage;
import org.eclipse.papyrus.gmf.mappings.LabelMapping;
import org.eclipse.papyrus.gmf.mappings.Language;
import org.eclipse.papyrus.gmf.mappings.MappingEntry;
import org.eclipse.papyrus.gmf.mappings.ValueExpression;

class MigrationDelegate
extends MigrationDelegateImpl {
    private final Map<LabelMapping, FeatureLabelMapping> myLabelMappingMigrations = new HashMap<LabelMapping, FeatureLabelMapping>();
    private EAttribute myLabelMapping_ViewPattern;
    private EAttribute myLabelMapping_EditPattern;
    private EReference myLabelMapping_Features;
    private EAttribute myFeatureValueSpec_Body;
    private EAttribute myFeatureValueSpec_Language;

    MigrationDelegate() {
    }

    void init() {
        this.registerNarrowedAbstractType("FeatureInitializer", GMFMapPackage.eINSTANCE.getFeatureValueSpec());
        this.myLabelMapping_Features = (EReference)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_Features());
        this.myLabelMapping_ViewPattern = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_ViewPattern());
        this.myLabelMapping_EditPattern = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_EditPattern());
        HashMap<String, Object> renamings = new HashMap<String, Object>();
        renamings.put(this.myLabelMapping_ViewPattern.getName(), this.myLabelMapping_ViewPattern);
        renamings.put(this.myLabelMapping_EditPattern.getName(), this.myLabelMapping_EditPattern);
        renamings.put(this.myLabelMapping_Features.getName(), this.myLabelMapping_Features);
        this.registerRenamedAttributes(GMFMapPackage.eINSTANCE.getLabelMapping(), renamings);
        this.myFeatureValueSpec_Body = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getValueExpression_Body());
        this.myFeatureValueSpec_Language = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getValueExpression_Language());
        renamings = new HashMap();
        renamings.put(this.myFeatureValueSpec_Body.getName(), this.myFeatureValueSpec_Body);
        renamings.put(this.myFeatureValueSpec_Language.getName(), this.myFeatureValueSpec_Language);
        this.registerRenamedAttributes(GMFMapPackage.eINSTANCE.getFeatureValueSpec(), renamings);
    }

    public boolean setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.myLabelMapping_ViewPattern.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            String viewPattern = (String)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.setViewPattern(viewPattern);
            this.fireMigrationApplied(true);
        } else if (this.myLabelMapping_EditPattern.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            String editPattern = (String)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.setViewPattern(editPattern);
            this.fireMigrationApplied(true);
        } else if (this.myLabelMapping_Features.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            EAttribute attribute = (EAttribute)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.getFeatures().add((Object)attribute);
            this.fireMigrationApplied(true);
        } else if (this.myFeatureValueSpec_Body.equals(feature)) {
            FeatureValueSpec featureRef = (FeatureValueSpec)object;
            String body = (String)value;
            ValueExpression constraint = this.getOrCreateValueExpression(featureRef);
            constraint.setBody(body);
            this.fireMigrationApplied(true);
        } else if (this.myFeatureValueSpec_Language.equals(feature)) {
            FeatureValueSpec featureRef = (FeatureValueSpec)object;
            ValueExpression constraint = this.getOrCreateValueExpression(featureRef);
            Language lang = Language.get((String)value);
            constraint.setLanguage(lang);
            this.fireMigrationApplied(true);
        } else {
            return super.setValue(object, feature, value, position);
        }
        return true;
    }

    private ValueExpression getOrCreateValueExpression(FeatureValueSpec featureRef) {
        ValueExpression constraint = featureRef.getValue();
        if (constraint == null) {
            constraint = GMFMapFactory.eINSTANCE.createValueExpression();
            featureRef.setValue(constraint);
        }
        return constraint;
    }

    private FeatureLabelMapping saveFeatureLabelMappingFor(LabelMapping labelMapping) {
        FeatureLabelMapping migrated = this.myLabelMappingMigrations.get(labelMapping);
        if (migrated == null) {
            migrated = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
            this.myLabelMappingMigrations.put(labelMapping, migrated);
        }
        return migrated;
    }

    public void preResolve() {
        for (LabelMapping mapping : this.myLabelMappingMigrations.keySet()) {
            MappingEntry entry;
            EList<LabelMapping> labelMappings;
            int originalIndex;
            FeatureLabelMapping migrated = this.myLabelMappingMigrations.get(mapping);
            if (migrated.getFeatures().isEmpty() || (originalIndex = (labelMappings = (entry = mapping.getMapEntry()).getLabelMappings()).indexOf((Object)mapping)) == -1) continue;
            migrated.setDiagramLabel(mapping.getDiagramLabel());
            if (mapping.isReadOnly()) {
                migrated.setReadOnly(true);
            }
            labelMappings.set(originalIndex, (Object)migrated);
        }
    }
}

