/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.tooldef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Separator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntryKind;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.NodeMapping;
import org.eclipse.papyrus.gmf.tooldef.AbstractTool;
import org.eclipse.papyrus.gmf.tooldef.BundleImage;
import org.eclipse.papyrus.gmf.tooldef.CreationTool;
import org.eclipse.papyrus.gmf.tooldef.GenericTool;
import org.eclipse.papyrus.gmf.tooldef.PaletteSeparator;
import org.eclipse.papyrus.gmf.tooldef.StandardTool;
import org.eclipse.papyrus.gmf.tooldef.ToolContainer;
import org.eclipse.papyrus.gmf.tooldef.ToolGroup;
import org.eclipse.papyrus.gmf.tooldef.util.GMFToolSwitch;
import org.osgi.framework.Bundle;

public class PaletteHandler {
    private final HashMap<AbstractTool, ToolGroupItem> myToolHistory = new HashMap();
    private Palette myGenPalette;
    private org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup myMisreferencedTools;

    public void initialize(Palette genPalette) {
        assert (genPalette != null);
        this.myGenPalette = genPalette;
        this.myToolHistory.clear();
    }

    protected final Palette getGenPalette() {
        assert (this.isInitialized());
        return this.myGenPalette;
    }

    protected final boolean isInitialized() {
        return this.myGenPalette != null;
    }

    public void process(org.eclipse.papyrus.gmf.tooldef.Palette palette) {
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup> groups = new ArrayList<org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup>(palette.getTools().size());
        ArrayList<ToolGroupItem> topLevelTools = new ArrayList<ToolGroupItem>(palette.getTools().size());
        for (ToolGroupItem next : new ToolSwitch(this.myToolHistory).toGroupItems((List<AbstractTool>)palette.getTools())) {
            if (next instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup) {
                groups.add((org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup)next);
                continue;
            }
            topLevelTools.add(next);
        }
        if (!topLevelTools.isEmpty()) {
            org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup defaultGroup = GMFGenFactory.eINSTANCE.createToolGroup();
            defaultGroup.setTitle("Default");
            defaultGroup.setDescription("Holds top-level non-container tools");
            defaultGroup.setCollapse(false);
            defaultGroup.getEntries().addAll(topLevelTools);
            this.getGenPalette().getGroups().add((Object)defaultGroup);
        }
        this.getGenPalette().getGroups().addAll(groups);
        if (palette.getDefault() != null) {
            assert (!(this.myToolHistory.get(palette.getDefault()) instanceof Separator));
            EntryBase eb = (EntryBase)this.myToolHistory.get(palette.getDefault());
            if (!(eb instanceof ToolEntry)) {
                PaletteHandler.logWarning("There's default tool specified for palette, but can't find gmfgen counterpart");
            } else {
                ((ToolEntry)eb).setDefault(true);
            }
        }
        this.getGenPalette().setFlyout(true);
    }

    public void process(NodeMapping nme, GenNode genNode) {
        if (!this.isInitialized() || nme.getTool() == null) {
            return;
        }
        ToolEntry te = this.toToolEntry(nme.getTool());
        if (te != null) {
            te.getGenNodes().add((Object)genNode);
        }
    }

    public void process(LinkMapping lme, GenLink genLink) {
        if (!this.isInitialized() || lme.getTool() == null) {
            return;
        }
        ToolEntry te = this.toToolEntry(lme.getTool());
        if (te != null) {
            te.getGenLinks().add((Object)genLink);
        }
    }

    private ToolEntry toToolEntry(AbstractTool tool) {
        if (PaletteHandler.checkIsContainer(tool)) {
            return null;
        }
        ToolEntry te = this.findToolEntry(tool);
        if (te == null) {
            te = this.createMissingToolEntry(tool);
        }
        return te;
    }

    private static boolean checkIsContainer(AbstractTool tool) {
        if (tool instanceof ToolContainer) {
            PaletteHandler.logWarning("Can't use container here");
            return true;
        }
        return false;
    }

    private ToolEntry findToolEntry(AbstractTool tool) {
        assert (!PaletteHandler.checkIsContainer(tool));
        return (ToolEntry)this.myToolHistory.get(tool);
    }

    private ToolEntry createMissingToolEntry(AbstractTool tool) {
        ToolEntry t;
        assert (tool != null);
        if (this.myMisreferencedTools == null) {
            this.myMisreferencedTools = GMFGenFactory.eINSTANCE.createToolGroup();
            this.myMisreferencedTools.setCollapse(false);
            this.myMisreferencedTools.setStack(false);
            this.myMisreferencedTools.setTitle("-- Mis-referenced tools --");
            this.myMisreferencedTools.setDescription("Mapping element referenced tools from palette other than one specified in Mapping instance");
            this.getGenPalette().getGroups().add((Object)this.myMisreferencedTools);
        }
        if ((t = (ToolEntry)new ToolSwitch(this.myToolHistory).doSwitch((EObject)tool)) != null) {
            this.myToolHistory.put(tool, (ToolGroupItem)t);
            this.myMisreferencedTools.getEntries().add((Object)t);
        }
        return t;
    }

    private static String constructIconPath(BundleImage icon) {
        assert (icon != null);
        if (icon.getPath() == null || icon.getPath().trim().length() == 0) {
            return null;
        }
        if (icon.getBundle() == null || icon.getBundle().trim().length() == 0) {
            return new Path(icon.getPath()).makeRelative().toString();
        }
        return new Path(icon.getBundle()).makeAbsolute().append(icon.getPath()).toString();
    }

    private static void logWarning(String message) {
        Bundle b = Platform.getBundle((String)"org.eclipse.papyrus.gmf.bridge");
        Platform.getLog((Bundle)b).log((IStatus)new Status(2, b.getSymbolicName(), 0, message, null));
    }

    private static class ToolSwitch
    extends GMFToolSwitch<ToolGroupItem> {
        private final Map<AbstractTool, ToolGroupItem> toolHistory;

        private ToolSwitch(Map<AbstractTool, ToolGroupItem> toolMap) {
            assert (toolMap != null);
            this.toolHistory = toolMap;
        }

        public List<ToolGroupItem> toGroupItems(List<AbstractTool> toolDefinitions) {
            assert (toolDefinitions != null);
            LinkedList<ToolGroupItem> rv = new LinkedList<ToolGroupItem>();
            for (AbstractTool next : toolDefinitions) {
                ToolGroupItem value = (ToolGroupItem)this.doSwitch((EObject)next);
                if (value == null) {
                    PaletteHandler.logWarning("Can't transform '" + next + " to ToolGroupItem");
                    continue;
                }
                this.toolHistory.put(next, value);
                rv.add(value);
            }
            return rv;
        }

        public ToolGroupItem casePaletteSeparator(PaletteSeparator object) {
            return GMFGenFactory.eINSTANCE.createSeparator();
        }

        public ToolGroupItem caseCreationTool(CreationTool tool) {
            ToolEntry ne = GMFGenFactory.eINSTANCE.createToolEntry();
            ToolSwitch.setupCommonToolEntry((EntryBase)ne, (AbstractTool)tool);
            return ne;
        }

        public ToolGroupItem caseStandardTool(StandardTool standardTool) {
            StandardEntry entry = GMFGenFactory.eINSTANCE.createStandardEntry();
            switch (standardTool.getToolKind().getValue()) {
                case 0: {
                    entry.setKind(StandardEntryKind.SELECT_LITERAL);
                    break;
                }
                case 2: {
                    entry.setKind(StandardEntryKind.MARQUEE_LITERAL);
                    break;
                }
                case 3: {
                    entry.setKind(StandardEntryKind.ZOOM_LITERAL);
                }
            }
            ToolSwitch.setupCommonToolEntry((EntryBase)entry, (AbstractTool)standardTool);
            return entry;
        }

        public ToolGroupItem caseGenericTool(GenericTool tool) {
            if (tool.getToolClass() == null) {
                PaletteHandler.logWarning("GenericTool element without a class, no palette entry createed");
                return null;
            }
            ToolEntry ne = GMFGenFactory.eINSTANCE.createToolEntry();
            ne.setQualifiedToolName(tool.getToolClass());
            ToolSwitch.setupCommonToolEntry((EntryBase)ne, (AbstractTool)tool);
            return ne;
        }

        public ToolGroupItem caseToolGroup(ToolGroup toolGroup) {
            org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup tg = GMFGenFactory.eINSTANCE.createToolGroup();
            tg.setCollapse(toolGroup.isCollapsible());
            tg.setStack(toolGroup.isStack());
            ToolSwitch.setupCommonToolEntry((EntryBase)tg, (AbstractTool)toolGroup);
            tg.getEntries().addAll(this.toGroupItems((List<AbstractTool>)toolGroup.getTools()));
            if (toolGroup.getActive() != null) {
                assert (!(this.toolHistory.get(toolGroup.getActive()) instanceof Separator));
                EntryBase eb = (EntryBase)this.toolHistory.get(toolGroup.getActive());
                if (eb == null || !(eb instanceof AbstractToolEntry)) {
                    PaletteHandler.logWarning("Can't find entry to became default in the group:" + toolGroup);
                } else {
                    ((AbstractToolEntry)eb).setDefault(true);
                }
            }
            return tg;
        }

        private static void setupCommonToolEntry(EntryBase te, AbstractTool tool) {
            te.setTitle(tool.getTitle() == null ? "" : tool.getTitle());
            te.setDescription(tool.getDescription());
            if (tool.getLargeIcon() instanceof BundleImage) {
                te.setLargeIconPath(PaletteHandler.constructIconPath((BundleImage)tool.getLargeIcon()));
            }
            if (tool.getSmallIcon() instanceof BundleImage) {
                te.setSmallIconPath(PaletteHandler.constructIconPath((BundleImage)tool.getSmallIcon()));
            }
        }
    }
}

