/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.resource;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.infra.internationalization.resource.InternationalizationResource;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationKeyResolver;

public class InternationalizationResourceFactory
extends XMIResourceFactoryImpl {
    public Resource createResource(URI uri) {
        InternationalizationResource resource = new InternationalizationResource(uri);
        if (!resource.getEncoding().equals("UTF-8")) {
            resource.setEncoding("UTF-8");
        }
        InternationalizationKeyResolver keyResolver = new InternationalizationKeyResolver();
        resource.getDefaultLoadOptions().put("internationalizationKeyResolver", keyResolver);
        String fileNameWithoutExtension = uri.trimFileExtension().toString();
        Locale localeFound = null;
        if (fileNameWithoutExtension.contains("_")) {
            List<Locale> availableLocales = Arrays.asList(Locale.getAvailableLocales());
            String substring = fileNameWithoutExtension;
            while (substring.contains("_") && localeFound == null) {
                substring = substring.substring(substring.indexOf("_") + 1);
                Iterator<Locale> localesIterator = availableLocales.iterator();
                while (localesIterator.hasNext() && localeFound == null) {
                    Locale currentAvailableLocale = localesIterator.next();
                    if (!currentAvailableLocale.toString().equals(substring)) continue;
                    localeFound = currentAvailableLocale;
                    fileNameWithoutExtension = fileNameWithoutExtension.substring(0, fileNameWithoutExtension.length() - substring.length() - 1);
                }
            }
        }
        resource.getDefaultLoadOptions().put("internationalizationURI", URI.createFileURI((String)fileNameWithoutExtension));
        if (localeFound != null) {
            resource.getDefaultLoadOptions().put("internationalizationLocale", localeFound);
        }
        return resource;
    }
}

