/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;

public class CustomBooleanStyleWithStoreObservableValue
extends CustomBooleanStyleObservableValue {
    protected IPreferenceStore preferenceStore;
    protected IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent event) {
            if (CustomBooleanStyleWithStoreObservableValue.this.styleName.equals(event.getProperty())) {
                ValueDiff diff = new ValueDiff(){

                    public Object getOldValue() {
                        return event.getOldValue();
                    }

                    public Object getNewValue() {
                        return event.getNewValue();
                    }
                };
                CustomBooleanStyleWithStoreObservableValue.this.fireValueChange(diff);
            }
        }
    };

    public CustomBooleanStyleWithStoreObservableValue(View source, EditingDomain domain, String styleName, IPreferenceStore preferenceStore) {
        super(source, domain, styleName);
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener(this.listener);
    }

    @Override
    public void handleChange(ChangeEvent event) {
        super.handleChange(event);
        this.addToPreferenceStore(this.doGetValue());
    }

    public void addToPreferenceStore(Object value) {
        if (value instanceof Boolean) {
            this.preferenceStore.setValue(this.styleName, ((Boolean)value).booleanValue());
        }
    }

    @Override
    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.listener);
        super.dispose();
    }

    @Override
    protected Boolean getDefaultValue() {
        return this.preferenceStore.getBoolean(this.styleName);
    }
}

