/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.utils.JobExecutorService;
import org.eclipse.papyrus.infra.emf.utils.InternalCrossReferencer;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;

public class ArchitectureIndex {
    private static final ArchitectureIndex INSTANCE = new ArchitectureIndex();
    private final ArchitectureDomainManager domainManager;
    private final Executor executor = new JobExecutorService();
    private final Map<Mode, Computation<Multimap<EObject, EStructuralFeature.Setting>>> crossReferences = new EnumMap<Mode, Computation<Multimap>>(Map.of(Mode.EXTERNAL_CROSS_REFERENCE, new Computation<Multimap>(this::computeExternalCrossReferences), Mode.INTERNAL_CROSS_REFERENCE, new Computation<Multimap>(this::computeInternalCrossReferences)));

    private ArchitectureIndex() {
        this.domainManager = ArchitectureDomainManager.getInstance();
        this.domainManager.addListener(this::domainManagerChanged);
    }

    public static ArchitectureIndex getInstance() {
        return INSTANCE;
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getCrossReferences(Mode crossReferenceMode) {
        return this.crossReferences.get((Object)crossReferenceMode).get();
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getExternalCrossReferences() {
        return this.getCrossReferences(Mode.EXTERNAL_CROSS_REFERENCE);
    }

    private Multimap<EObject, EStructuralFeature.Setting> computeExternalCrossReferences() {
        Set architectureDomains = ArchitectureDomainManager.getInstance().getMerger().getDomains().stream().map(MergedADElement::getMergedElements).flatMap(Collection::stream).collect(Collectors.toSet());
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry next : EcoreUtil.ExternalCrossReferencer.find(architectureDomains).entrySet()) {
            result.putAll((Object)((EObject)next.getKey()), (Iterable)next.getValue());
        }
        return result.build();
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getInternalCrossReferences() {
        return this.getCrossReferences(Mode.INTERNAL_CROSS_REFERENCE);
    }

    private Multimap<EObject, EStructuralFeature.Setting> computeInternalCrossReferences() {
        Set architectureDomains = ArchitectureDomainManager.getInstance().getMerger().getDomains().stream().map(MergedADElement::getMergedElements).flatMap(Collection::stream).collect(Collectors.toSet());
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry next : InternalCrossReferencer.find(architectureDomains).entrySet()) {
            result.putAll((Object)((EObject)next.getKey()), (Iterable)next.getValue());
        }
        return result.build();
    }

    private void domainManagerChanged() {
        this.crossReferences.values().forEach(Computation::reset);
    }

    public boolean isReferenced(Mode crossReferenceMode, Resource resource) {
        return this.isReferenced(crossReferenceMode, resource, null);
    }

    public boolean isReferenced(Mode crossReferenceMode, Resource resource, EReference reference) {
        return Optional.ofNullable(resource).map(Resource::getResourceSet).map(context -> this.isReferenced(crossReferenceMode, resource.getURI(), reference, (ResourceSet)context)).orElse(false);
    }

    public boolean isReferenced(EObject object) {
        return this.isReferenced(object, null);
    }

    public boolean isReferenced(EObject object, EReference reference) {
        return Optional.ofNullable(object).map(EObject::eResource).map(Resource::getResourceSet).map(context -> this.isReferenced(ArchitectureIndex.inferCrossReferenceMode(object), EcoreUtil.getURI((EObject)object), reference, (ResourceSet)context)).orElse(false);
    }

    private static Mode inferCrossReferenceMode(EObject object) {
        return object instanceof ADElement ? Mode.INTERNAL_CROSS_REFERENCE : (object != null && object.eContainer() != null ? ArchitectureIndex.inferCrossReferenceMode(object.eContainer()) : Mode.EXTERNAL_CROSS_REFERENCE);
    }

    public boolean isReferenced(Mode crossReferenceMode, URI uri, ResourceSet context) {
        return this.isReferenced(crossReferenceMode, uri, null, context);
    }

    public boolean isReferenced(Mode crossReferenceMode, URI uri, EReference reference, ResourceSet context) {
        boolean result = false;
        try {
            CompletableFuture<Boolean> futureResult = this.isReferencedAsync(crossReferenceMode, uri, reference, context);
            result = Boolean.TRUE.equals(futureResult.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying Architecture Context models.", (Throwable)e);
        }
        return result;
    }

    public CompletableFuture<Boolean> isReferencedAsync(Mode crossReferenceMode, URI uri, EReference reference, ResourceSet context) {
        URIConverter converter = context.getURIConverter();
        Function<Object, Object> uriTrimmer = uri.hasFragment() ? Function.identity() : URI::trimFragment;
        Predicate<Map.Entry> referenceFilter = reference == null ? __ -> true : entry -> ((EStructuralFeature.Setting)entry.getValue()).getEStructuralFeature() == reference;
        Predicate<Multimap> isReferenced = xrefs -> xrefs.entries().stream().filter(referenceFilter).map(Map.Entry::getKey).map(EcoreUtil::getURI).map(uriTrimmer).map(arg_0 -> ((URIConverter)converter).normalize(arg_0)).anyMatch(uri::equals);
        return this.getCrossReferences(crossReferenceMode).thenApply(isReferenced::test);
    }

    private final class Computation<T>
    implements Supplier<CompletableFuture<T>> {
        private final AtomicReference<CompletableFuture<T>> computation = new AtomicReference();
        private final Supplier<T> computer;

        Computation(Supplier<T> computer) {
            this.computer = computer;
        }

        @Override
        public CompletableFuture<T> get() {
            CompletableFuture newResult = new CompletableFuture();
            CompletableFuture<T> result = this.computation.compareAndExchange(null, newResult);
            if (result == null) {
                result = newResult;
                result.completeAsync(this.computer, ArchitectureIndex.this.executor);
            }
            return result;
        }

        void reset() {
            Optional.ofNullable(this.computation.getAndSet(null)).ifPresent(future -> {
                boolean bl = future.cancel(false);
            });
        }
    }

    public static enum Mode {
        EXTERNAL_CROSS_REFERENCE,
        INTERNAL_CROSS_REFERENCE;

    }
}

