/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesDependencies;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;

public class ElementTypesCustomValidator
extends CustomModelChecker.SwitchValidator {
    public ElementTypesCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(ElementTypeSetConfiguration setConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String bundleName;
        String nsURI = setConfiguration.getMetamodelNsURI();
        if (nsURI != null && !nsURI.isBlank() && (bundleName = BundleResourceURIHelper.INSTANCE.getBundleNameFromNS_URI(nsURI)) == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)setConfiguration, this.format(Messages.ElementTypesCustomValidator_0, context, new Object[]{setConfiguration, nsURI})));
        }
    }

    public void validate(IconEntry iconEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            ElementTypesDependencies.getIconURI(iconEntry).ifPresent(uri -> {
                ResourceSet rset = iconEntry.eResource().getResourceSet();
                if (!rset.getURIConverter().exists(uri, null)) {
                    diagnostics.add(this.createDiagnostic(4, (EObject)iconEntry, this.format(Messages.ElementTypesCustomValidator_2, context, new Object[]{iconEntry.eContainer(), uri.lastSegment()})));
                }
            });
        }
        catch (Exception e) {
            diagnostics.add(this.createDiagnostic(4, (EObject)iconEntry, this.format(Messages.ElementTypesCustomValidator_1, context, new Object[]{iconEntry.eContainer(), iconEntry.getIconPath()})));
        }
    }
}

