/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.util.ElementTypesConfigurationsSwitch;
import org.eclipse.pde.core.plugin.PluginRegistry;

class ElementTypesDependencies {
    private final String hostBundle;

    ElementTypesDependencies(IProject project) {
        this.hostBundle = PluginRegistry.findModel((IProject)project).getBundleDescription().getSymbolicName();
    }

    Set<String> computeDependencies(Resource resource) {
        return new DependenciesSwitch().doSwitch(resource);
    }

    static Optional<URI> getIconURI(IconEntry iconEntry) {
        if (iconEntry.getIconPath() == null) {
            return Optional.empty();
        }
        String bundleID = iconEntry.getBundleId();
        if (bundleID == null) {
            bundleID = iconEntry.eResource().getURI().segment(1);
        }
        IPath path = new Path(bundleID).append((IPath)new Path(iconEntry.getIconPath()));
        return Optional.of(URI.createPlatformPluginURI((String)path.toString(), (boolean)true));
    }

    final class DependenciesSwitch
    extends ComposedSwitch<Set<String>> {
        private final Set<String> result = new HashSet<String>();

        DependenciesSwitch() {
            this.addSwitch(this.createElementTypesSwitch());
        }

        public Set<String> defaultCase(EObject object) {
            object.eContents().forEach(arg_0 -> ((DependenciesSwitch)this).doSwitch(arg_0));
            return this.result;
        }

        Set<String> doSwitch(Resource resource) {
            resource.getContents().forEach(arg_0 -> ((DependenciesSwitch)this).doSwitch(arg_0));
            return this.result;
        }

        private Switch<Set<String>> createElementTypesSwitch() {
            return new ElementTypesConfigurationsSwitch<Set<String>>(){

                public Set<String> caseIconEntry(IconEntry object) {
                    String bundleID = object.getBundleId();
                    if (bundleID != null && !bundleID.equals(((DependenciesSwitch)DependenciesSwitch.this).ElementTypesDependencies.this.hostBundle)) {
                        DependenciesSwitch.this.result.add(bundleID);
                    }
                    return null;
                }

                public Set<String> caseElementTypeSetConfiguration(ElementTypeSetConfiguration object) {
                    Optional.ofNullable(object.getMetamodelNsURI()).map(arg_0 -> ((BundleResourceURIHelper)BundleResourceURIHelper.INSTANCE).getBundleNameFromNS_URI(arg_0)).ifPresent(DependenciesSwitch.this.result::add);
                    return null;
                }
            };
        }
    }
}

