/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ApplyStereotypeAdviceCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesBuildPropertiesDependencies;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesDependencies;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesPluginXMLValidator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.StereotypeApplicationMatcherCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.StereotypePropertyReferenceEdgeAdviceCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;

public class ElementTypesPluginChecker {
    public static final String ELEMENT_TYPES_CONFIGURATION_EXTENSION = "elementtypesconfigurations";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.types.core", "org.eclipse.papyrus.infra.types");

    public static void checkElementTypesPlugin(IProject project, IProgressMonitor monitor) {
        Collection elementTypesFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)ELEMENT_TYPES_CONFIGURATION_EXTENSION, (boolean)true);
        monitor.beginTask(Messages.ElementTypesPluginChecker_0, 1 + elementTypesFiles.size() * 3);
        monitor.subTask(Messages.ElementTypesPluginChecker_1);
        MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic");
        PluginValidationService pluginValidationService = new PluginValidationService();
        pluginValidationService.addPluginChecker((IPluginChecker)ElementTypesPluginChecker.createModelDependenciesChecker(project));
        for (IFile elementTypesFile : elementTypesFiles) {
            if (monitor.isCanceled()) {
                return;
            }
            URI elementTypesFileURI = URI.createPlatformResourceURI((String)elementTypesFile.getFullPath().toOSString(), (boolean)true);
            Resource resource = new ResourceSetImpl().getResource(elementTypesFileURI, true);
            pluginValidationService.addPluginChecker((IPluginChecker)ElementTypesPluginChecker.createModelValidationChecker(project, elementTypesFile, resource));
            pluginValidationService.addPluginChecker(ElementTypesPluginChecker.createExtensionsChecker(project, elementTypesFile, resource));
            pluginValidationService.addPluginChecker((IPluginChecker)ElementTypesPluginChecker.createModelDependenciesChecker(project, elementTypesFile, resource));
        }
        monitor.worked(1);
        pluginValidationService.validate(monitor);
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(ElementTypesPluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(ElementTypesPluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic").withAdditionalRequirements(new ElementTypesDependencies(project)::computeDependencies);
    }

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ElementTypesPluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ElementTypesPluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic").withDependencies(file -> new ElementTypesBuildPropertiesDependencies(resource).getDependencies());
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ElementTypesPluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<ElementTypeSetConfiguration, PluginErrorReporter<ElementTypeSetConfiguration>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection sets = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION);
        return new ExtensionsChecker(project, modelFile, sets, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", ElementTypesPluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<ElementTypeSetConfiguration> createPluginErrorReporter(IFile pluginXML, IFile modelFile, ElementTypeSetConfiguration model) {
        ElementTypesPluginXMLValidator validator = new ElementTypesPluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", set -> set.getIdentifier()).softRequireExtensionPoint("org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration", validator::matchExtension, validator::checkExtension, validator::problemID);
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ElementTypesPluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic").withValidator("http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.2", ElementTypesCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/uml/types/applystereotypeadvice/1.1", ApplyStereotypeAdviceCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/uml/types/stereotypematcher/1.1", StereotypeApplicationMatcherCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/uml/types/stereotypepropertyreferenceedgeadvice/1.0", StereotypePropertyReferenceEdgeAdviceCustomValidator::new);
    }
}

